/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.constructor;

import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.api.ConstructNode;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.constructor.BaseConstructor;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.env.EnvConfig;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.exceptions.ConstructorException;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.exceptions.DuplicateKeyException;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.exceptions.MissingEnvironmentVariableException;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.Node;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.NodeType;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.Tag;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.resolver.JsonScalarResolver;
import java.math.BigInteger;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;

public class StandardConstructor
extends BaseConstructor {
    private static final Map<String, Boolean> BOOL_VALUES = new HashMap<String, Boolean>();

    public StandardConstructor(LoadSettings settings) {
        super(settings);
        this.tagConstructors.put(Tag.NULL, new ConstructYamlNull());
        this.tagConstructors.put(Tag.BOOL, new ConstructYamlBool());
        this.tagConstructors.put(Tag.INT, new ConstructYamlInt());
        this.tagConstructors.put(Tag.FLOAT, new ConstructYamlFloat());
        this.tagConstructors.put(Tag.BINARY, new ConstructYamlBinary());
        this.tagConstructors.put(Tag.SET, new ConstructYamlSet());
        this.tagConstructors.put(Tag.STR, new ConstructYamlStr());
        this.tagConstructors.put(Tag.SEQ, new ConstructYamlSeq());
        this.tagConstructors.put(Tag.MAP, new ConstructYamlMap());
        this.tagConstructors.put(Tag.ENV_TAG, new ConstructEnv());
        this.tagConstructors.put(new Tag(UUID.class), new ConstructUuidClass());
        this.tagConstructors.put(new Tag(Optional.class), new ConstructOptionalClass());
        this.tagConstructors.putAll(settings.getTagConstructors());
    }

    protected void flattenMapping(MappingNode node) {
        this.processDuplicateKeys(node);
    }

    protected void processDuplicateKeys(MappingNode node) {
        List<NodeTuple> nodeValue = node.getValue();
        HashMap<Object, Integer> keys2 = new HashMap<Object, Integer>(nodeValue.size());
        TreeSet<Integer> toRemove = new TreeSet<Integer>();
        int i = 0;
        for (NodeTuple tuple : nodeValue) {
            Node keyNode = tuple.getKeyNode();
            Object key = this.constructKey(keyNode, node.getStartMark(), tuple.getKeyNode().getStartMark());
            Integer prevIndex = keys2.put(key, i);
            if (prevIndex != null) {
                if (!this.settings.getAllowDuplicateKeys()) {
                    throw new DuplicateKeyException(node.getStartMark(), key, tuple.getKeyNode().getStartMark());
                }
                toRemove.add(prevIndex);
            }
            ++i;
        }
        Iterator indices2remove = toRemove.descendingIterator();
        while (indices2remove.hasNext()) {
            nodeValue.remove((Integer)indices2remove.next());
        }
    }

    private Object constructKey(Node keyNode, Optional<Mark> contextMark, Optional<Mark> problemMark) {
        Object key = this.constructObject(keyNode);
        if (key != null) {
            try {
                key.hashCode();
            }
            catch (Exception e) {
                throw new ConstructorException("while constructing a mapping", contextMark, "found unacceptable key " + key, problemMark, e);
            }
        }
        return key;
    }

    @Override
    protected void constructMapping2ndStep(MappingNode node, Map<Object, Object> mapping) {
        this.flattenMapping(node);
        super.constructMapping2ndStep(node, mapping);
    }

    @Override
    protected void constructSet2ndStep(MappingNode node, Set<Object> set2) {
        this.flattenMapping(node);
        super.constructSet2ndStep(node, set2);
    }

    static {
        BOOL_VALUES.put("true", Boolean.TRUE);
        BOOL_VALUES.put("false", Boolean.FALSE);
    }

    public class ConstructEnv
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String val = StandardConstructor.this.constructScalar((ScalarNode)node);
            Optional<EnvConfig> opt = StandardConstructor.this.settings.getEnvConfig();
            if (opt.isPresent()) {
                EnvConfig config2 = opt.get();
                Matcher matcher = JsonScalarResolver.ENV_FORMAT.matcher(val);
                matcher.matches();
                String name2 = matcher.group(1);
                String value2 = matcher.group(3);
                String nonNullValue = value2 != null ? value2 : "";
                String separator = matcher.group(2);
                String env = this.getEnv(name2);
                Optional<String> overruled = config2.getValueFor(name2, separator, nonNullValue, env);
                if (overruled.isPresent()) {
                    return overruled.get();
                }
                return this.apply(name2, separator, nonNullValue, env);
            }
            return val;
        }

        public String apply(String name2, String separator, String value2, String environment) {
            if (environment != null && !environment.isEmpty()) {
                return environment;
            }
            if (separator != null) {
                if (separator.equals("?") && environment == null) {
                    throw new MissingEnvironmentVariableException("Missing mandatory variable " + name2 + ": " + value2);
                }
                if (separator.equals(":?")) {
                    if (environment == null) {
                        throw new MissingEnvironmentVariableException("Missing mandatory variable " + name2 + ": " + value2);
                    }
                    if (environment.isEmpty()) {
                        throw new MissingEnvironmentVariableException("Empty mandatory variable " + name2 + ": " + value2);
                    }
                }
                if (separator.startsWith(":") ? environment == null || environment.isEmpty() : environment == null) {
                    return value2;
                }
            }
            return "";
        }

        public String getEnv(String key) {
            return System.getenv(key);
        }
    }

    public class ConstructYamlMap
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            MappingNode mappingNode = (MappingNode)node;
            if (node.isRecursive()) {
                return StandardConstructor.this.createDefaultMap(mappingNode.getValue().size());
            }
            return StandardConstructor.this.constructMapping(mappingNode);
        }

        @Override
        public void constructRecursive(Node node, Object object) {
            if (!node.isRecursive()) {
                throw new YamlEngineException("Unexpected recursive mapping structure. Node: " + node);
            }
            StandardConstructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
        }
    }

    public class ConstructYamlSeq
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            SequenceNode seqNode = (SequenceNode)node;
            if (node.isRecursive()) {
                return StandardConstructor.this.settings.getDefaultList().apply(seqNode.getValue().size());
            }
            return StandardConstructor.this.constructSequence(seqNode);
        }

        @Override
        public void constructRecursive(Node node, Object data2) {
            if (!node.isRecursive()) {
                throw new YamlEngineException("Unexpected recursive sequence structure. Node: " + node);
            }
            StandardConstructor.this.constructSequenceStep2((SequenceNode)node, (List)data2);
        }
    }

    public class ConstructYamlStr
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            return StandardConstructor.this.constructScalar((ScalarNode)node);
        }
    }

    public class ConstructYamlSet
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            if (node.isRecursive()) {
                return StandardConstructor.this.constructedObjects.containsKey(node) ? StandardConstructor.this.constructedObjects.get(node) : StandardConstructor.this.createDefaultSet(((MappingNode)node).getValue().size());
            }
            return StandardConstructor.this.constructSet((MappingNode)node);
        }

        @Override
        public void constructRecursive(Node node, Object object) {
            if (!node.isRecursive()) {
                throw new YamlEngineException("Unexpected recursive set structure. Node: " + node);
            }
            StandardConstructor.this.constructSet2ndStep((MappingNode)node, (Set)object);
        }
    }

    public class ConstructOptionalClass
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            if (node.getNodeType() != NodeType.SCALAR) {
                throw new ConstructorException("while constructing Optional", Optional.empty(), "found non scalar node", node.getStartMark());
            }
            String value2 = StandardConstructor.this.constructScalar((ScalarNode)node);
            Tag implicitTag = StandardConstructor.this.settings.getScalarResolver().resolve(value2, true);
            if (implicitTag.equals(Tag.NULL)) {
                return Optional.empty();
            }
            return Optional.of(value2);
        }
    }

    public class ConstructUuidClass
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String uuidValue = StandardConstructor.this.constructScalar((ScalarNode)node);
            return UUID.fromString(uuidValue);
        }
    }

    public class ConstructYamlBinary
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String noWhiteSpaces = StandardConstructor.this.constructScalar((ScalarNode)node).replaceAll("\\s", "");
            return Base64.getDecoder().decode(noWhiteSpaces);
        }
    }

    public class ConstructYamlFloat
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String value2 = StandardConstructor.this.constructScalar((ScalarNode)node);
            int sign = 1;
            char first2 = value2.charAt(0);
            if (first2 == '-') {
                sign = -1;
                value2 = value2.substring(1);
            } else if (first2 == '+') {
                value2 = value2.substring(1);
            }
            if (".inf".equals(value2)) {
                return sign == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (".nan".equals(value2)) {
                return Double.NaN;
            }
            Double d = Double.valueOf(value2);
            return d * (double)sign;
        }
    }

    public class ConstructYamlInt
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String value2 = StandardConstructor.this.constructScalar((ScalarNode)node);
            return this.createIntNumber(value2);
        }

        protected Number createIntNumber(String number2) {
            Number result2;
            try {
                result2 = Integer.valueOf(number2);
            }
            catch (NumberFormatException e) {
                try {
                    result2 = Long.valueOf(number2);
                }
                catch (NumberFormatException e1) {
                    result2 = new BigInteger(number2);
                }
            }
            return result2;
        }
    }

    public class ConstructYamlBool
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String val = StandardConstructor.this.constructScalar((ScalarNode)node);
            return BOOL_VALUES.get(val.toLowerCase());
        }
    }

    public class ConstructYamlNull
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            if (node != null) {
                StandardConstructor.this.constructScalar((ScalarNode)node);
            }
            return null;
        }
    }
}

