/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.api.lowlevel;

import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.api.lowlevel.EmitableEvents;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.events.Event;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.Node;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.serializer.Serializer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Serialize {
    private final DumpSettings settings;

    public Serialize(DumpSettings settings) {
        Objects.requireNonNull(settings, "DumpSettings cannot be null");
        this.settings = settings;
    }

    public List<Event> serializeOne(Node node) {
        Objects.requireNonNull(node, "Node cannot be null");
        return this.serializeAll(Collections.singletonList(node));
    }

    public List<Event> serializeAll(List<Node> nodes) {
        Objects.requireNonNull(nodes, "Nodes cannot be null");
        EmitableEvents emitableEvents = new EmitableEvents();
        Serializer serializer2 = new Serializer(this.settings, emitableEvents);
        serializer2.emitStreamStart();
        for (Node node : nodes) {
            serializer2.serializeDocument(node);
        }
        serializer2.emitStreamEnd();
        return emitableEvents.getEvents();
    }
}

