/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.engine;

import dev.bloedarend.plugin.YamlDocument;
import dev.bloedarend.plugin.block.Block;
import dev.bloedarend.plugin.block.Comments;
import dev.bloedarend.plugin.block.implementation.Section;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.api.RepresentToNode;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.Node;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.representer.StandardRepresenter;
import dev.bloedarend.plugin.settings.general.GeneralSettings;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedRepresenter
extends StandardRepresenter {
    private final GeneralSettings generalSettings;

    public ExtendedRepresenter(@NotNull GeneralSettings generalSettings, @NotNull DumpSettings dumpSettings) {
        super(dumpSettings);
        this.generalSettings = generalSettings;
        RepresentSection representSection = new RepresentSection();
        RepresentSerializable representSerializable = new RepresentSerializable();
        this.representers.put(Section.class, representSection);
        this.representers.put(YamlDocument.class, representSection);
        this.representers.put(Enum.class, new RepresentEnum());
        for (Class<?> clazz : generalSettings.getSerializer().getSupportedClasses()) {
            this.representers.put(clazz, representSerializable);
        }
        for (Class<?> clazz : generalSettings.getSerializer().getSupportedParentClasses()) {
            this.parentClassRepresenters.put(clazz, representSerializable);
        }
    }

    @NotNull
    public Node applyKeyComments(@Nullable Block<?> block2, @NotNull Node node) {
        if (block2 != null) {
            node.setBlockComments(Comments.get(block2, Comments.NodeType.KEY, Comments.Position.BEFORE));
            node.setInLineComments(Comments.get(block2, Comments.NodeType.KEY, Comments.Position.INLINE));
            node.setEndComments(Comments.get(block2, Comments.NodeType.KEY, Comments.Position.AFTER));
        }
        return node;
    }

    @NotNull
    public Node applyValueComments(@Nullable Block<?> block2, @NotNull Node node) {
        if (block2 != null) {
            node.setBlockComments(Comments.get(block2, Comments.NodeType.VALUE, Comments.Position.BEFORE));
            node.setInLineComments(Comments.get(block2, Comments.NodeType.VALUE, Comments.Position.INLINE));
            node.setEndComments(Comments.get(block2, Comments.NodeType.VALUE, Comments.Position.AFTER));
        }
        return node;
    }

    @Override
    protected NodeTuple representMappingEntry(Map.Entry<?, ?> entry) {
        Block block2 = entry.getValue() instanceof Block ? (Block)entry.getValue() : null;
        Node key = this.applyKeyComments(block2, this.representData(entry.getKey()));
        Node value2 = this.applyValueComments(block2, this.representData(block2 == null ? entry.getValue() : block2.getStoredValue()));
        return new NodeTuple(key, value2);
    }

    private class RepresentEnum
    implements RepresentToNode {
        private RepresentEnum() {
        }

        @Override
        public Node representData(Object data2) {
            return ExtendedRepresenter.this.representData(((Enum)data2).name());
        }
    }

    private class RepresentSection
    implements RepresentToNode {
        private RepresentSection() {
        }

        @Override
        public Node representData(Object data2) {
            Section section = (Section)data2;
            return ExtendedRepresenter.this.applyKeyComments(section, ExtendedRepresenter.this.representData(section.getStoredValue()));
        }
    }

    private class RepresentSerializable
    implements RepresentToNode {
        private RepresentSerializable() {
        }

        @Override
        public Node representData(Object data2) {
            Map<Object, Object> serialized = ExtendedRepresenter.this.generalSettings.getSerializer().serialize(data2, ExtendedRepresenter.this.generalSettings.getDefaultMapSupplier());
            return ExtendedRepresenter.this.representData(serialized == null ? data2 : serialized);
        }
    }
}

