/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.dvs.segment;

import dev.bloedarend.plugin.dvs.segment.Segment;
import java.util.Arrays;

public class RangeSegment
implements Segment {
    private final int start;
    private final int end;
    private final int step;
    private final int minStringLength;
    private final int maxStringLength;
    private final int fill;
    private final int length;

    public RangeSegment(int start2, int end2, int step, int fill) {
        this.start = start2;
        this.end = end2;
        this.step = step;
        this.fill = fill;
        if (step == 0) {
            throw new IllegalArgumentException("Step cannot be zero!");
        }
        if (start2 < end2 && step < 0 || start2 > end2 && step > 0) {
            throw new IllegalArgumentException(String.format("Invalid step for the given range! start=%d end=%d step=%d", start2, end2, step));
        }
        if (start2 == end2) {
            throw new IllegalArgumentException(String.format("Parameters define an empty range, start=end! start=%d end=%d", start2, end2));
        }
        this.length = (int)Math.ceil((double)Math.abs(start2 - end2) / (double)Math.abs(step));
        int last2 = start2 + step * (this.length - 1);
        if (start2 < 0 || end2 < 0 && last2 < 0) {
            throw new IllegalArgumentException(String.format("Range contains negative integers! start=%d end=%d step=%d", start2, end2, step));
        }
        if (fill > 0 && !this.validateFill(fill, Math.max(start2, last2))) {
            throw new IllegalArgumentException(String.format("Some integer from the range exceeds maximum length defined by the filling parameter! start=%d end=%d last=%d fill=%d", start2, end2, last2, fill));
        }
        int n = fill > 0 ? fill : (this.maxStringLength = this.countDigits(step > 0 ? end2 : start2));
        this.minStringLength = fill > 0 ? fill : this.countDigits(step > 0 ? start2 : end2);
    }

    @Deprecated
    public RangeSegment(int start2, int end2) {
        this(start2, end2, start2 < end2 ? 1 : -1, 0);
    }

    @Deprecated
    public RangeSegment(int start2, int end2, int step) {
        this(start2, end2, step, 0);
    }

    private boolean validateFill(int fill, int maxValue2) {
        int maxFillValue = 9;
        for (int i = 0; i < fill; ++i) {
            if (maxFillValue >= maxValue2) {
                return true;
            }
            maxFillValue *= 10;
            maxFillValue += 9;
        }
        return false;
    }

    @Override
    public int parse(String versionId, int index) {
        int digit;
        if (this.fill > 0) {
            if (this.fill > versionId.length() - index) {
                return -1;
            }
            try {
                return this.getRangeIndex(Integer.parseInt(versionId.substring(index, this.fill)));
            }
            catch (NumberFormatException ignored) {
                return -1;
            }
        }
        if (versionId.length() <= index) {
            return -1;
        }
        int value2 = 0;
        int digits = 0;
        for (int i = 0; i < this.maxStringLength && i < versionId.length() - index && (i != 1 || value2 != 0 || digits != 1) && (digit = Character.digit(versionId.charAt(index + i), 10)) != -1; value2 += digit, ++digits, ++i) {
            value2 *= 10;
        }
        if (digits == 0) {
            return -1;
        }
        if (value2 == 0) {
            return this.getRangeIndex(0);
        }
        while (value2 > 0 && digits >= this.minStringLength) {
            int rangeIndex = this.getRangeIndex(value2);
            if (rangeIndex != -1) {
                return rangeIndex;
            }
            value2 /= 10;
            --digits;
        }
        return -1;
    }

    private int countDigits(int value2) {
        if (value2 == 0) {
            return 1;
        }
        int digits = 0;
        while (value2 > 0) {
            value2 /= 10;
            ++digits;
        }
        return digits;
    }

    private int getRangeIndex(int value2) {
        if (this.step > 0 ? this.start > value2 || this.end <= value2 : this.start < value2 || this.end >= value2) {
            return -1;
        }
        int diff = Math.abs(value2 - this.start);
        if (value2 >= 0 && diff % this.step == 0) {
            return diff / Math.abs(this.step);
        }
        return -1;
    }

    @Override
    public String getElement(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds! i=%d length=%d", index, this.length));
        }
        String value2 = Integer.toString(this.start + this.step * index, 10);
        if (this.fill <= 0 || value2.length() == this.fill) {
            return value2;
        }
        char[] fill = new char[this.fill - value2.length()];
        Arrays.fill(fill, '0');
        return new StringBuilder(value2).insert(0, fill).toString();
    }

    @Override
    public int getElementLength(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds! i=%d length=%d", index, this.length));
        }
        return this.fill > 0 ? this.fill : this.countDigits(this.start + this.step * index);
    }

    @Override
    public int length() {
        return this.length;
    }

    public String toString() {
        return "RangeSegment{start=" + this.start + ", end=" + this.end + ", step=" + this.step + ", fill=" + this.fill + ", length=" + this.length + '}';
    }
}

