/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.block;

import dev.bloedarend.plugin.block.Block;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.comments.CommentType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Comments {
    public static final CommentLine BLANK_LINE = new CommentLine(Optional.empty(), Optional.empty(), "", CommentType.BLANK_LINE);

    @Nullable
    public static List<CommentLine> get(@NotNull Block<?> block2, @NotNull NodeType node, @NotNull Position position2) {
        switch (position2) {
            case BEFORE: {
                return node == NodeType.KEY ? block2.beforeKeyComments : block2.beforeValueComments;
            }
            case INLINE: {
                return node == NodeType.KEY ? block2.inlineKeyComments : block2.inlineValueComments;
            }
            case AFTER: {
                return node == NodeType.KEY ? block2.afterKeyComments : block2.afterValueComments;
            }
        }
        return null;
    }

    public static void set(@NotNull Block<?> block2, @NotNull NodeType node, @NotNull Position position2, @Nullable List<CommentLine> comments) {
        if (comments != null) {
            comments = new ArrayList<CommentLine>(comments);
        }
        switch (position2) {
            case BEFORE: {
                if (node == NodeType.KEY) {
                    block2.beforeKeyComments = comments;
                    break;
                }
                block2.beforeValueComments = comments;
                break;
            }
            case INLINE: {
                if (node == NodeType.KEY) {
                    block2.inlineKeyComments = comments;
                    break;
                }
                block2.inlineValueComments = comments;
                break;
            }
            case AFTER: {
                if (node == NodeType.KEY) {
                    block2.afterKeyComments = comments;
                    break;
                }
                block2.afterValueComments = comments;
            }
        }
    }

    public static void remove(@NotNull Block<?> block2, @NotNull NodeType node, @NotNull Position position2) {
        Comments.set(block2, node, position2, null);
    }

    public static void add(@NotNull Block<?> block2, @NotNull NodeType node, @NotNull Position position2, @NotNull List<CommentLine> comments) {
        comments.forEach(comment -> Comments.add(block2, node, position2, comment));
    }

    public static void add(@NotNull Block<?> block2, @NotNull NodeType node, @NotNull Position position2, @NotNull CommentLine comment) {
        switch (position2) {
            case BEFORE: {
                if (node == NodeType.KEY) {
                    if (block2.beforeKeyComments == null) {
                        block2.beforeKeyComments = new ArrayList<CommentLine>();
                    }
                    block2.beforeKeyComments.add(comment);
                    break;
                }
                if (block2.beforeValueComments == null) {
                    block2.beforeValueComments = new ArrayList<CommentLine>();
                }
                block2.beforeValueComments.add(comment);
                break;
            }
            case INLINE: {
                if (node == NodeType.KEY) {
                    if (block2.inlineKeyComments == null) {
                        block2.inlineKeyComments = new ArrayList<CommentLine>();
                    }
                    block2.inlineKeyComments.add(comment);
                    break;
                }
                if (block2.inlineValueComments == null) {
                    block2.inlineValueComments = new ArrayList<CommentLine>();
                }
                block2.inlineValueComments.add(comment);
                break;
            }
            case AFTER: {
                if (node == NodeType.KEY) {
                    if (block2.afterKeyComments == null) {
                        block2.afterKeyComments = new ArrayList<CommentLine>();
                    }
                    block2.afterKeyComments.add(comment);
                    break;
                }
                if (block2.afterValueComments == null) {
                    block2.afterValueComments = new ArrayList<CommentLine>();
                }
                block2.afterValueComments.add(comment);
            }
        }
    }

    @NotNull
    public static CommentLine create(@NotNull String comment, @NotNull Position position2) {
        return new CommentLine(Optional.empty(), Optional.empty(), comment, position2 == Position.INLINE ? CommentType.IN_LINE : CommentType.BLOCK);
    }

    public static enum NodeType {
        KEY,
        VALUE;

    }

    public static enum Position {
        BEFORE,
        INLINE,
        AFTER;

    }
}

