/*
 * Decompiled with CFR 0.152.
 */
package dev.bloedarend.plugin.block;

import dev.bloedarend.plugin.block.Comments;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.comments.CommentType;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.Node;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import dev.bloedarend.plugin.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Block<T> {
    List<CommentLine> beforeKeyComments = new ArrayList<CommentLine>(0);
    List<CommentLine> inlineKeyComments = null;
    List<CommentLine> afterKeyComments = null;
    List<CommentLine> beforeValueComments = null;
    List<CommentLine> inlineValueComments = null;
    List<CommentLine> afterValueComments = null;
    private final T value;
    private boolean ignored;

    public Block(@Nullable Node keyNode, @Nullable Node valueNode, @Nullable T value2) {
        this.value = value2;
        this.init(keyNode, valueNode);
    }

    public Block(@Nullable T value2) {
        this(null, null, value2);
    }

    public Block(@Nullable Block<?> previous, @Nullable T value2) {
        this.value = value2;
        if (previous == null) {
            return;
        }
        this.beforeKeyComments = previous.beforeKeyComments;
        this.inlineKeyComments = previous.inlineKeyComments;
        this.afterKeyComments = previous.afterKeyComments;
        this.beforeValueComments = previous.beforeValueComments;
        this.inlineValueComments = previous.inlineValueComments;
        this.afterValueComments = previous.afterValueComments;
    }

    protected void init(@Nullable Node key, @Nullable Node value2) {
        if (key != null) {
            List<Object> list = this.beforeKeyComments = key.getBlockComments() == null ? new ArrayList(0) : key.getBlockComments();
            if (key.getInLineComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(key.getInLineComments()));
            }
            if (key.getEndComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(key.getEndComments()));
            }
            this.collectComments(key, true);
        }
        if (value2 != null) {
            this.beforeValueComments = value2.getBlockComments();
            if (this.beforeKeyComments == null) {
                this.beforeKeyComments = new ArrayList<CommentLine>(0);
            }
            if (value2.getInLineComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(value2.getInLineComments()));
            }
            if (value2.getEndComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(value2.getEndComments()));
            }
            this.collectComments(value2, true);
        }
    }

    private void collectComments(@NotNull Node node, boolean initial) {
        block9: {
            block8: {
                if (!initial) {
                    if (node.getBlockComments() != null) {
                        this.beforeKeyComments.addAll(this.toBlockComments(node.getBlockComments()));
                    }
                    if (node.getInLineComments() != null) {
                        this.beforeKeyComments.addAll(this.toBlockComments(node.getInLineComments()));
                    }
                    if (node.getEndComments() != null) {
                        this.beforeKeyComments.addAll(this.toBlockComments(node.getEndComments()));
                    }
                } else if (this.beforeKeyComments == null) {
                    this.beforeKeyComments = new ArrayList<CommentLine>(0);
                }
                if (!(node instanceof SequenceNode)) break block8;
                SequenceNode sequenceNode = (SequenceNode)node;
                for (Node sub : sequenceNode.getValue()) {
                    this.collectComments(sub, false);
                }
                break block9;
            }
            if (initial || !(node instanceof MappingNode)) break block9;
            MappingNode mappingNode = (MappingNode)node;
            for (NodeTuple sub : mappingNode.getValue()) {
                this.collectComments(sub.getKeyNode(), false);
                this.collectComments(sub.getValueNode(), false);
            }
        }
    }

    private List<CommentLine> toBlockComments(@NotNull List<CommentLine> commentLines) {
        int i = -1;
        for (CommentLine commentLine : commentLines) {
            commentLines.set(++i, commentLine.getCommentType() != CommentType.IN_LINE ? commentLine : new CommentLine(commentLine.getStartMark(), commentLine.getEndMark(), commentLine.getValue(), CommentType.BLOCK));
        }
        return commentLines;
    }

    @Nullable
    public List<String> getComments() {
        List<CommentLine> comments = Comments.get(this, Comments.NodeType.KEY, Comments.Position.BEFORE);
        if (comments == null) {
            return null;
        }
        return comments.stream().map(CommentLine::getValue).collect(Collectors.toList());
    }

    public void setComments(@Nullable List<String> comments) {
        Comments.set(this, Comments.NodeType.KEY, Comments.Position.BEFORE, comments == null ? null : comments.stream().map(comment -> Comments.create(comment, Comments.Position.BEFORE)).collect(Collectors.toList()));
    }

    public void removeComments() {
        Comments.remove(this, Comments.NodeType.KEY, Comments.Position.BEFORE);
    }

    public void addComments(@NotNull List<String> comments) {
        Comments.add(this, Comments.NodeType.KEY, Comments.Position.BEFORE, comments.stream().map(comment -> Comments.create(comment, Comments.Position.BEFORE)).collect(Collectors.toList()));
    }

    public void addComment(@NotNull String comment) {
        Comments.add(this, Comments.NodeType.KEY, Comments.Position.BEFORE, Comments.create(comment, Comments.Position.BEFORE));
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public abstract boolean isSection();

    public T getStoredValue() {
        return this.value;
    }
}

