/*
 * Decompiled with CFR 0.152.
 */
package com.vdurmont.emoji;

import com.vdurmont.emoji.Emoji;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmojiTrie {
    private final Node root = new Node();
    final int maxDepth;

    public EmojiTrie(Collection<Emoji> emojis) {
        int maxDepth = 0;
        for (Emoji emoji2 : emojis) {
            Node tree = this.root;
            char[] chars = emoji2.getUnicode().toCharArray();
            maxDepth = Math.max(maxDepth, chars.length);
            for (char c : chars) {
                if (!tree.hasChild(c)) {
                    tree.addChild(c);
                }
                tree = tree.getChild(c);
            }
            tree.setEmoji(emoji2);
        }
        this.maxDepth = maxDepth;
    }

    public Matches isEmoji(char[] sequence) {
        return this.isEmoji(sequence, 0, sequence.length);
    }

    public Matches isEmoji(char[] sequence, int start2, int end2) {
        if (start2 < 0 || start2 > end2 || end2 > sequence.length) {
            throw new ArrayIndexOutOfBoundsException("start " + start2 + ", end " + end2 + ", length " + sequence.length);
        }
        if (sequence == null) {
            return Matches.POSSIBLY;
        }
        Node tree = this.root;
        for (int i = start2; i < end2; ++i) {
            if (!tree.hasChild(sequence[i])) {
                return Matches.IMPOSSIBLE;
            }
            tree = tree.getChild(sequence[i]);
        }
        return tree.isEndOfEmoji() ? Matches.EXACTLY : Matches.POSSIBLY;
    }

    public Emoji getEmoji(String unicode) {
        return this.getEmoji(unicode.toCharArray(), 0, unicode.length());
    }

    Emoji getEmoji(char[] sequence, int start2, int end2) {
        if (start2 < 0 || start2 > end2 || end2 > sequence.length) {
            throw new ArrayIndexOutOfBoundsException("start " + start2 + ", end " + end2 + ", length " + sequence.length);
        }
        Node tree = this.root;
        for (int i = 0; i < end2; ++i) {
            if (!tree.hasChild(sequence[i])) {
                return null;
            }
            tree = tree.getChild(sequence[i]);
        }
        return tree.getEmoji();
    }

    private class Node {
        private Map<Character, Node> children = new HashMap<Character, Node>();
        private Emoji emoji;

        private Node() {
        }

        private void setEmoji(Emoji emoji2) {
            this.emoji = emoji2;
        }

        private Emoji getEmoji() {
            return this.emoji;
        }

        private boolean hasChild(char child) {
            return this.children.containsKey(Character.valueOf(child));
        }

        private void addChild(char child) {
            this.children.put(Character.valueOf(child), new Node());
        }

        private Node getChild(char child) {
            return this.children.get(Character.valueOf(child));
        }

        private boolean isEndOfEmoji() {
            return this.emoji != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Matches {
        EXACTLY,
        POSSIBLY,
        IMPOSSIBLE;


        public boolean exactMatch() {
            return this == EXACTLY;
        }

        public boolean impossibleMatch() {
            return this == IMPOSSIBLE;
        }
    }
}

