/*
 * Decompiled with CFR 0.152.
 */
package com.github.shynixn.mccoroutine.bukkit.impl;

import com.github.shynixn.mccoroutine.bukkit.CoroutineSession;
import com.github.shynixn.mccoroutine.bukkit.MCCoroutine;
import com.github.shynixn.mccoroutine.bukkit.impl.CoroutineSessionImpl;
import com.github.shynixn.mccoroutine.bukkit.impl.MCCoroutineConfigurationImpl;
import com.github.shynixn.mccoroutine.bukkit.listener.PluginListener;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Server;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/shynixn/mccoroutine/bukkit/impl/MCCoroutineImpl;", "Lcom/github/shynixn/mccoroutine/bukkit/MCCoroutine;", "()V", "items", "Ljava/util/HashMap;", "Lorg/bukkit/plugin/Plugin;", "Lcom/github/shynixn/mccoroutine/bukkit/impl/CoroutineSessionImpl;", "Lkotlin/collections/HashMap;", "disable", "", "plugin", "getCoroutineSession", "Lcom/github/shynixn/mccoroutine/bukkit/CoroutineSession;", "startCoroutineSession", "mccoroutine-bukkit-core"})
public final class MCCoroutineImpl
implements MCCoroutine {
    private final HashMap<Plugin, CoroutineSessionImpl> items = new HashMap();

    @Override
    @NotNull
    public CoroutineSession getCoroutineSession(@NotNull Plugin plugin) {
        Intrinsics.checkParameterIsNotNull(plugin, "plugin");
        if (!this.items.containsKey(plugin)) {
            this.startCoroutineSession(plugin);
        }
        CoroutineSessionImpl coroutineSessionImpl = this.items.get(plugin);
        if (coroutineSessionImpl == null) {
            Intrinsics.throwNpe();
        }
        return coroutineSessionImpl;
    }

    @Override
    public void disable(@NotNull Plugin plugin) {
        Intrinsics.checkParameterIsNotNull(plugin, "plugin");
        if (!this.items.containsKey(plugin)) {
            return;
        }
        CoroutineSessionImpl coroutineSessionImpl = this.items.get(plugin);
        if (coroutineSessionImpl == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(coroutineSessionImpl, "items[plugin]!!");
        CoroutineSessionImpl session2 = coroutineSessionImpl;
        session2.dispose();
        this.items.remove(plugin);
    }

    private final void startCoroutineSession(Plugin plugin) {
        if (!plugin.isEnabled()) {
            throw (Throwable)new RuntimeException("Plugin " + plugin.getName() + " attempted to start a new coroutine session while being disabled. Dispatchers such as plugin.minecraftDispatcher and plugin.asyncDispatcher are using the BukkitScheduler, which is already disposed at this point of time. If you are starting a coroutine in onDisable, consider using runBlocking or a different plugin.mcCoroutineConfiguration.shutdownStrategy. See https://shynixn.github.io/MCCoroutine/wiki/site/plugindisable for details.");
        }
        PluginListener pluginListener = new PluginListener(this, plugin);
        MCCoroutineConfigurationImpl coroutineFacade = new MCCoroutineConfigurationImpl(plugin, this);
        ((Map)this.items).put(plugin, new CoroutineSessionImpl(plugin, coroutineFacade));
        Server server = plugin.getServer();
        Intrinsics.checkExpressionValueIsNotNull(server, "plugin.server");
        server.getPluginManager().registerEvents((Listener)pluginListener, plugin);
    }
}

