/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.config;

import dev.blaauwendraad.masker.json.ValueMasker;
import dev.blaauwendraad.masker.json.config.KeyMaskingConfig;
import dev.blaauwendraad.masker.json.path.JsonPath;
import dev.blaauwendraad.masker.json.path.JsonPathParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;

public final class JsonMaskingConfig {
    private final TargetKeyMode targetKeyMode;
    private final Set<String> targetKeys;
    private final Set<JsonPath> targetJsonPaths;
    private final boolean caseSensitiveTargetKeys;
    private final KeyMaskingConfig defaultConfig;
    private final Map<String, KeyMaskingConfig> targetKeyConfigs;

    JsonMaskingConfig(Builder builder) {
        if (builder.targetKeyMode == null) {
            throw new IllegalArgumentException("No keys were requested to mask or allow");
        }
        this.targetKeyMode = builder.targetKeyMode;
        this.targetKeys = builder.targetKeys;
        this.targetJsonPaths = builder.targetJsonPaths;
        this.caseSensitiveTargetKeys = builder.caseSensitiveTargetKeys != null && builder.caseSensitiveTargetKeys != false;
        this.defaultConfig = builder.defaultConfigBuilder.build();
        this.targetKeyConfigs = builder.targetKeyConfigs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isInAllowMode() {
        return this.targetKeyMode == TargetKeyMode.ALLOW;
    }

    public boolean isInMaskMode() {
        return this.targetKeyMode == TargetKeyMode.MASK;
    }

    public Set<String> getTargetKeys() {
        return this.targetKeys;
    }

    public Set<JsonPath> getTargetJsonPaths() {
        return this.targetJsonPaths;
    }

    public boolean caseSensitiveTargetKeys() {
        return this.caseSensitiveTargetKeys;
    }

    public KeyMaskingConfig getConfig(String key) {
        return this.targetKeyConfigs.getOrDefault(key, this.defaultConfig);
    }

    public KeyMaskingConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public Map<String, KeyMaskingConfig> getKeyConfigs() {
        return Collections.unmodifiableMap(this.targetKeyConfigs);
    }

    public String toString() {
        return "targetKeys=%s,\ntargetJsonPaths=%s,\ntargetKeyMode=%s,\ncaseSensitiveTargetKeys=%s,\ndefaultConfig=%s,\ntargetKeyConfigs=%s\n".formatted(new Object[]{this.targetKeys, this.targetJsonPaths, this.targetKeyMode, this.caseSensitiveTargetKeys, this.defaultConfig, this.targetKeyConfigs});
    }

    public static class Builder {
        private static final JsonPathParser JSON_PATH_PARSER = new JsonPathParser();
        private final Set<String> targetKeys = new HashSet<String>();
        private final Set<JsonPath> targetJsonPaths = new HashSet<JsonPath>();
        private TargetKeyMode targetKeyMode;
        private Boolean caseSensitiveTargetKeys;
        private final KeyMaskingConfig.Builder defaultConfigBuilder = KeyMaskingConfig.builder();
        private final Map<String, KeyMaskingConfig> targetKeyConfigs = new HashMap<String, KeyMaskingConfig>();

        private Builder() {
        }

        public Builder maskKeys(Set<String> keys) {
            if (this.targetKeyMode == TargetKeyMode.ALLOW) {
                throw new IllegalArgumentException("Cannot mask keys when in ALLOW mode, if you want to customize masking for specific keys in ALLOW mode, use maskKeys(String key, KeyMaskingConfig config)");
            }
            return this.maskKeys0(keys, null);
        }

        public Builder maskKeys(Set<String> keys, KeyMaskingConfig config) {
            return this.maskKeys0(keys, Objects.requireNonNull(config));
        }

        private Builder maskKeys0(Set<String> keys, @CheckForNull KeyMaskingConfig config) {
            if (keys.isEmpty()) {
                throw new IllegalArgumentException("At least one key must be provided");
            }
            for (String key : keys) {
                if (this.targetKeys.contains(key) || this.targetKeyConfigs.containsKey(key)) {
                    throw new IllegalArgumentException("Duplicate key '%s'".formatted(key));
                }
                if (this.targetKeyMode != TargetKeyMode.ALLOW) {
                    this.targetKeyMode = TargetKeyMode.MASK;
                    this.targetKeys.add(key);
                }
                if (config == null) continue;
                this.targetKeyConfigs.put(key, config);
            }
            return this;
        }

        public Builder maskJsonPaths(Set<String> jsonPaths) {
            if (this.targetKeyMode == TargetKeyMode.ALLOW) {
                throw new IllegalArgumentException("Cannot mask json paths when in ALLOW mode, if you want to customize masking for specific json paths in ALLOW mode, use maskJsonPaths(String jsonPath, KeyMaskingConfig config)");
            }
            return this.maskJsonPaths0(jsonPaths, null);
        }

        public Builder maskJsonPaths(Set<String> jsonPaths, KeyMaskingConfig config) {
            return this.maskJsonPaths0(jsonPaths, Objects.requireNonNull(config));
        }

        private Builder maskJsonPaths0(Set<String> jsonPaths, @CheckForNull KeyMaskingConfig config) {
            if (jsonPaths.isEmpty()) {
                throw new IllegalArgumentException("At least one json path must be provided");
            }
            for (String jsonPath : jsonPaths) {
                JsonPath parsed = JSON_PATH_PARSER.parse(jsonPath);
                if (this.targetJsonPaths.contains(parsed) || this.targetKeyConfigs.containsKey(parsed.toString())) {
                    throw new IllegalArgumentException("Duplicate json path '%s'".formatted(jsonPath));
                }
                if (this.targetKeyMode != TargetKeyMode.ALLOW) {
                    this.targetKeyMode = TargetKeyMode.MASK;
                    this.targetJsonPaths.add(parsed);
                }
                if (config == null) continue;
                this.targetKeyConfigs.put(parsed.toString(), config);
            }
            return this;
        }

        public Builder allowKeys(Set<String> keys) {
            if (this.targetKeyMode == TargetKeyMode.MASK) {
                throw new IllegalArgumentException("Cannot allow keys when in MASK mode");
            }
            this.targetKeyMode = TargetKeyMode.ALLOW;
            for (String key : keys) {
                if (this.targetKeys.contains(key)) {
                    throw new IllegalArgumentException("Duplicate key '%s'".formatted(key));
                }
                this.targetKeys.add(key);
            }
            return this;
        }

        public Builder allowJsonPaths(Set<String> jsonPaths) {
            if (this.targetKeyMode == TargetKeyMode.MASK) {
                throw new IllegalArgumentException("Cannot allow keys when in MASK mode");
            }
            if (jsonPaths.isEmpty()) {
                throw new IllegalArgumentException("At least one json path must be provided");
            }
            this.targetKeyMode = TargetKeyMode.ALLOW;
            for (String jsonPath : jsonPaths) {
                JsonPath parsed = JSON_PATH_PARSER.parse(jsonPath);
                if (this.targetJsonPaths.contains(parsed)) {
                    throw new IllegalArgumentException("Duplicate json path '%s'".formatted(jsonPath));
                }
                this.targetJsonPaths.add(parsed);
            }
            return this;
        }

        public Builder caseSensitiveTargetKeys() {
            if (this.caseSensitiveTargetKeys != null) {
                throw new IllegalArgumentException("Case sensitivity already set");
            }
            this.caseSensitiveTargetKeys = true;
            return this;
        }

        public Builder maskStringsWith(String value) {
            this.defaultConfigBuilder.maskStringsWith(value);
            return this;
        }

        public Builder maskStringCharactersWith(String value) {
            this.defaultConfigBuilder.maskStringCharactersWith(value);
            return this;
        }

        public Builder maskStringsWith(ValueMasker.StringMasker valueMasker) {
            this.defaultConfigBuilder.maskStringsWith(valueMasker);
            return this;
        }

        public Builder maskNumbersWith(String value) {
            this.defaultConfigBuilder.maskNumbersWith(value);
            return this;
        }

        public Builder maskNumbersWith(int value) {
            this.defaultConfigBuilder.maskNumbersWith(value);
            return this;
        }

        public Builder maskNumberDigitsWith(int digit) {
            this.defaultConfigBuilder.maskNumberDigitsWith(digit);
            return this;
        }

        public Builder maskNumbersWith(ValueMasker.NumberMasker valueMasker) {
            this.defaultConfigBuilder.maskNumbersWith(valueMasker);
            return this;
        }

        public Builder maskBooleansWith(String value) {
            this.defaultConfigBuilder.maskBooleansWith(value);
            return this;
        }

        public Builder maskBooleansWith(boolean value) {
            this.defaultConfigBuilder.maskBooleansWith(value);
            return this;
        }

        public Builder maskBooleansWith(ValueMasker.BooleanMasker valueMasker) {
            this.defaultConfigBuilder.maskBooleansWith(valueMasker);
            return this;
        }

        public JsonMaskingConfig build() {
            JSON_PATH_PARSER.checkAmbiguity(this.targetJsonPaths);
            return new JsonMaskingConfig(this);
        }
    }

    public static enum TargetKeyMode {
        ALLOW,
        MASK;

    }
}

