/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.json.DescriptiveValueMasker;
import dev.blaauwendraad.masker.json.ValueMasker;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

public final class ValueMaskers {
    private ValueMaskers() {
    }

    public static <T extends ValueMasker> T describe(String description, T delegate) {
        return (T)new DescriptiveValueMasker<T>(description, delegate);
    }

    public static ValueMasker.AnyValueMasker with(String value) {
        String replacement = "\"" + value + "\"";
        byte[] replacementBytes = replacement.getBytes(StandardCharsets.UTF_8);
        return ValueMaskers.describe(replacement, context -> context.replaceBytes(0, context.byteLength(), replacementBytes, 1));
    }

    public static ValueMasker.AnyValueMasker with(int value) {
        byte[] replacementBytes = String.valueOf(value).getBytes(StandardCharsets.UTF_8);
        return ValueMaskers.describe(String.valueOf(value), context -> context.replaceBytes(0, context.byteLength(), replacementBytes, 1));
    }

    public static ValueMasker.AnyValueMasker with(boolean value) {
        byte[] replacementBytes = String.valueOf(value).getBytes(StandardCharsets.UTF_8);
        return ValueMaskers.describe(String.valueOf(value), context -> context.replaceBytes(0, context.byteLength(), replacementBytes, 1));
    }

    public static ValueMasker.AnyValueMasker withNull() {
        byte[] replacementBytes = "null".getBytes(StandardCharsets.UTF_8);
        return ValueMaskers.describe("null (literal)", context -> context.replaceBytes(0, context.byteLength(), replacementBytes, 1));
    }

    public static ValueMasker.StringMasker eachCharacterWith(String value) {
        byte[] replacementBytes = value.getBytes(StandardCharsets.UTF_8);
        return ValueMaskers.describe("every character as %s".formatted(value), context -> {
            int stringValueStart = 1;
            int stringValueLength = context.byteLength() - 2;
            int nonVisibleCharacters = context.countNonVisibleCharacters(stringValueStart, stringValueLength);
            int maskLength = stringValueLength - nonVisibleCharacters;
            context.replaceBytes(stringValueStart, stringValueLength, replacementBytes, maskLength);
        });
    }

    public static ValueMasker.NumberMasker eachDigitWith(int digit) {
        if (digit < 1 || digit > 9) {
            throw new IllegalArgumentException("Masking digit must be between 1 and 9 to avoid leading zeroes which is invalid in JSON");
        }
        byte[] replacementBytes = String.valueOf(digit).getBytes(StandardCharsets.UTF_8);
        return ValueMaskers.describe("every digit as %s".formatted(digit), context -> context.replaceBytes(0, context.byteLength(), replacementBytes, context.byteLength()));
    }

    public static ValueMasker.AnyValueMasker noop() {
        return ValueMaskers.describe("<no masking>", context -> {});
    }

    public static ValueMasker.StringMasker email(int keepPrefixLength, int keepSuffixLength, boolean keepDomain, String mask) {
        byte[] replacementBytes = mask.getBytes(StandardCharsets.UTF_8);
        return ValueMaskers.describe("email, keep prefix: %s, keep suffix: %s, keep domain: %s".formatted(keepPrefixLength, keepSuffixLength, keepDomain), context -> {
            int maskLength;
            int prefixLength = keepPrefixLength + 1;
            int suffixLength = keepSuffixLength + 1;
            if (keepDomain) {
                for (int i = 0; i < context.byteLength(); ++i) {
                    if (context.getByte(i) != 64) continue;
                    suffixLength = context.byteLength() - i + keepSuffixLength;
                    break;
                }
            }
            if ((maskLength = context.byteLength() - prefixLength - suffixLength) > 0) {
                context.replaceBytes(prefixLength, maskLength, replacementBytes, 1);
            }
        });
    }

    public static ValueMasker.AnyValueMasker withRawValueFunction(Function<String, String> masker) {
        return ValueMaskers.describe("withRawValueFunction (%s)".formatted(masker), context -> {
            String value = context.asString(0, context.byteLength());
            String maskedValue = (String)masker.apply(value);
            if (maskedValue == null) {
                maskedValue = "null";
            }
            context.replaceBytes(0, context.byteLength(), maskedValue.getBytes(StandardCharsets.UTF_8), 1);
        });
    }
}

