/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.json.JsonPathNode;
import dev.blaauwendraad.masker.json.ValueMaskerContext;
import dev.blaauwendraad.masker.json.util.Utf8Util;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

final class MaskingState
implements ValueMaskerContext {
    private final byte[] message;
    private int currentIndex = 0;
    private final List<ReplacementOperation> replacementOperations = new ArrayList<ReplacementOperation>();
    private int replacementOperationsTotalDifference = 0;
    private final Deque<JsonPathNode> currentJsonPath;
    private int currentValueStartIndex = -1;

    public MaskingState(byte[] message, boolean trackJsonPath) {
        this.message = message;
        this.currentJsonPath = trackJsonPath ? new ArrayDeque<JsonPathNode>() : null;
    }

    public boolean next() {
        return ++this.currentIndex < this.message.length;
    }

    public void incrementIndex(int length) {
        this.currentIndex += length;
    }

    public byte byteAtCurrentIndex() {
        return this.message[this.currentIndex];
    }

    public boolean endOfJson() {
        return this.currentIndex == this.message.length;
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void replaceTargetValueWith(int startIndex, int length, byte[] mask, int maskRepeat) {
        ReplacementOperation replacementOperation = new ReplacementOperation(startIndex, length, mask, maskRepeat);
        this.replacementOperations.add(replacementOperation);
        this.replacementOperationsTotalDifference += replacementOperation.difference();
    }

    public byte[] flushReplacementOperations() {
        if (this.replacementOperations.isEmpty()) {
            return this.message;
        }
        byte[] newMessage = new byte[this.message.length + this.replacementOperationsTotalDifference];
        int index = 0;
        int offset = 0;
        for (ReplacementOperation replacementOperation : this.replacementOperations) {
            System.arraycopy(this.message, index, newMessage, index + offset, replacementOperation.startIndex - index);
            int length = replacementOperation.mask.length;
            for (int i = 0; i < replacementOperation.maskRepeat; ++i) {
                System.arraycopy(replacementOperation.mask, 0, newMessage, replacementOperation.startIndex + offset + i * length, length);
            }
            index = replacementOperation.startIndex + replacementOperation.length;
            offset += replacementOperation.difference();
        }
        System.arraycopy(this.message, index, newMessage, index + offset, this.message.length - index);
        this.currentIndex = Integer.MAX_VALUE;
        return newMessage;
    }

    boolean jsonPathEnabled() {
        return this.currentJsonPath != null;
    }

    void expandCurrentJsonPath(int start, int offset) {
        if (this.currentJsonPath != null) {
            this.currentJsonPath.push(new JsonPathNode.Node(start, offset));
        }
    }

    void expandCurrentJsonPathWithArray() {
        if (this.currentJsonPath != null) {
            this.currentJsonPath.push(new JsonPathNode.Array());
        }
    }

    void backtrackCurrentJsonPath() {
        if (this.currentJsonPath != null) {
            this.currentJsonPath.pop();
        }
    }

    Iterator<JsonPathNode> getCurrentJsonPath() {
        if (this.currentJsonPath != null) {
            return this.currentJsonPath.descendingIterator();
        }
        return Collections.emptyIterator();
    }

    public int getCurrentValueStartIndex() {
        if (this.currentValueStartIndex == -1) {
            throw new IllegalStateException("No current value index set to mask");
        }
        return this.currentValueStartIndex;
    }

    public void registerValueStartIndex() {
        this.currentValueStartIndex = this.currentIndex;
    }

    public void clearValueStartIndex() {
        this.currentValueStartIndex = -1;
    }

    @Override
    public byte getByte(int index) {
        this.checkCurrentValueBounds(index);
        return this.message[this.getCurrentValueStartIndex() + index];
    }

    @Override
    public int byteLength() {
        return this.currentIndex - this.getCurrentValueStartIndex();
    }

    @Override
    public void replaceBytes(int fromIndex, int length, byte[] mask, int maskRepeat) {
        this.checkCurrentValueBounds(fromIndex);
        this.checkCurrentValueBounds(fromIndex + length - 1);
        this.replaceTargetValueWith(this.getCurrentValueStartIndex() + fromIndex, length, mask, maskRepeat);
    }

    @Override
    public int countNonVisibleCharacters(int fromIndex, int length) {
        this.checkCurrentValueBounds(fromIndex);
        this.checkCurrentValueBounds(fromIndex + length - 1);
        return Utf8Util.countNonVisibleCharacters(this.message, this.getCurrentValueStartIndex() + fromIndex, length);
    }

    @Override
    public String asString(int fromIndex, int length) {
        this.checkCurrentValueBounds(fromIndex);
        this.checkCurrentValueBounds(fromIndex + length - 1);
        int offset = this.getCurrentValueStartIndex();
        return new String(this.message, offset + fromIndex, length, StandardCharsets.UTF_8);
    }

    private void checkCurrentValueBounds(int index) {
        if (index < 0 || index >= this.byteLength()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for value of length " + this.byteLength());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(new String(this.message, Math.max(0, this.currentIndex - 10), Math.min(10, this.currentIndex)));
        sb.append(">");
        if (this.currentIndex == this.message.length) {
            sb.append("<end of json>");
        } else {
            sb.append((char)this.message[this.currentIndex]);
            if (this.currentIndex + 1 < this.message.length) {
                sb.append("<");
                sb.append(new String(this.message, this.currentIndex + 1, Math.min(10, this.message.length - this.currentIndex - 1)));
            }
        }
        return sb.toString();
    }

    private record ReplacementOperation(int startIndex, int length, byte[] mask, int maskRepeat) {
        public int difference() {
            return this.mask.length * this.maskRepeat - this.length;
        }
    }
}

