/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.json.JsonPathNode;
import dev.blaauwendraad.masker.json.config.JsonMaskingConfig;
import dev.blaauwendraad.masker.json.config.KeyMaskingConfig;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.annotation.CheckForNull;

final class KeyMatcher {
    private static final int BYTE_OFFSET = 128;
    private static final int SKIP_KEY_LOOKUP = -1;
    private final JsonMaskingConfig maskingConfig;
    private final TrieNode root;
    private final boolean[] knownByteLengths = new boolean[256];

    public KeyMatcher(JsonMaskingConfig maskingConfig) {
        this.maskingConfig = maskingConfig;
        this.root = new TrieNode();
        maskingConfig.getTargetKeys().forEach(key -> this.insert((String)key, false));
        maskingConfig.getTargetJsonPaths().forEach(jsonPath -> this.insert(jsonPath.toString(), false));
        if (maskingConfig.isInAllowMode()) {
            maskingConfig.getKeyConfigs().keySet().forEach(key -> this.insert((String)key, true));
        }
    }

    private void insert(String word, boolean negativeMatch) {
        boolean caseInsensitive = !this.maskingConfig.caseSensitiveTargetKeys();
        byte[] bytes = word.getBytes(StandardCharsets.UTF_8);
        this.knownByteLengths[bytes.length] = true;
        byte[] lowerBytes = null;
        byte[] upperBytes = null;
        if (caseInsensitive) {
            lowerBytes = word.toLowerCase().getBytes(StandardCharsets.UTF_8);
            upperBytes = word.toUpperCase().getBytes(StandardCharsets.UTF_8);
            if (bytes.length != lowerBytes.length || bytes.length != upperBytes.length) {
                throw new IllegalArgumentException("Case insensitive trie does not support all characters in " + word);
            }
        }
        TrieNode node = this.root;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            TrieNode child = node.children[b + 128];
            if (child == null) {
                node.children[b + 128] = child = new TrieNode();
                if (caseInsensitive) {
                    node.children[lowerBytes[i] + 128] = child;
                    node.children[upperBytes[i] + 128] = child;
                }
            }
            node = child;
        }
        node.keyMaskingConfig = this.maskingConfig.getConfig(word);
        node.endOfWord = true;
        node.negativeMatch = negativeMatch;
    }

    @CheckForNull
    public KeyMaskingConfig getMaskConfigIfMatched(byte[] bytes, int keyOffset, int keyLength, Iterator<? extends JsonPathNode> jsonPath) {
        if (this.maskingConfig.isInMaskMode()) {
            TrieNode node = this.searchForJsonPathKeyNode(bytes, jsonPath);
            if (node != null && !node.negativeMatch) {
                return node.keyMaskingConfig;
            }
            if (keyLength != -1 && (node = this.searchNode(bytes, keyOffset, keyLength)) != null && !node.negativeMatch) {
                return node.keyMaskingConfig;
            }
            return null;
        }
        TrieNode node = this.searchForJsonPathKeyNode(bytes, jsonPath);
        if (node != null) {
            if (node.negativeMatch) {
                return node.keyMaskingConfig;
            }
            return null;
        }
        if (keyLength != -1 && (node = this.searchNode(bytes, keyOffset, keyLength)) != null) {
            if (node.negativeMatch) {
                return node.keyMaskingConfig;
            }
            return null;
        }
        return this.maskingConfig.getDefaultConfig();
    }

    @CheckForNull
    private TrieNode searchNode(byte[] bytes, int offset, int length) {
        if (!this.knownByteLengths[length]) {
            return null;
        }
        TrieNode node = this.root;
        for (int i = offset; i < offset + length; ++i) {
            byte b = bytes[i];
            node = node.children[b + 128];
            if (node != null) continue;
            return null;
        }
        if (!node.endOfWord) {
            return null;
        }
        return node;
    }

    @CheckForNull
    private TrieNode searchForJsonPathKeyNode(byte[] bytes, Iterator<? extends JsonPathNode> jsonPath) {
        TrieNode node = this.root;
        node = node.children[164];
        if (node == null) {
            return null;
        }
        if (node.endOfWord) {
            return node;
        }
        while (jsonPath.hasNext()) {
            node = node.children[174];
            if (node == null) {
                return null;
            }
            JsonPathNode jsonPathSegmentReference = jsonPath.next();
            TrieNode wildcardLookAhead = node.children[170];
            if (wildcardLookAhead != null && (wildcardLookAhead.endOfWord || wildcardLookAhead.children[174] != null)) {
                node = wildcardLookAhead;
                if (!node.endOfWord) continue;
                return node;
            }
            if (jsonPathSegmentReference instanceof JsonPathNode.Node) {
                JsonPathNode.Node jsonPathNode = (JsonPathNode.Node)jsonPathSegmentReference;
                int keyOffset = jsonPathNode.getOffset();
                int keyLength = jsonPathNode.getLength();
                for (int i = keyOffset; i < keyOffset + keyLength; ++i) {
                    byte b = bytes[i];
                    node = node.children[b + 128];
                    if (node != null) continue;
                    return null;
                }
                continue;
            }
            if (jsonPathSegmentReference instanceof JsonPathNode.Array) {
                return null;
            }
            throw new IllegalStateException("Unknown json path segment reference type " + jsonPathSegmentReference.getClass());
        }
        if (!node.endOfWord) {
            return null;
        }
        return node;
    }

    private static class TrieNode {
        private final TrieNode[] children = new TrieNode[256];
        private boolean endOfWord = false;
        @CheckForNull
        private KeyMaskingConfig keyMaskingConfig = null;
        private boolean negativeMatch = false;

        private TrieNode() {
        }
    }
}

