/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.util;

import dev.blaauwendraad.masker.json.util.AsciiCharacter;

public final class Utf8Util {
    private Utf8Util() {
    }

    public static int getCodePointByteLength(byte input) {
        int shift = 7;
        int mostSignificantBitValue = input >> shift & 1;
        if (mostSignificantBitValue == 0) {
            return 1;
        }
        if ((input >> --shift & 1) == 0) {
            return 0;
        }
        --shift;
        while (shift > 2) {
            int bitValue = input >> shift & 1;
            if (bitValue == 0) {
                return 7 - shift;
            }
            --shift;
        }
        throw new IllegalArgumentException("Input byte is not using UTF-8 encoding");
    }

    public static int countNonVisibleCharacters(byte[] message, int fromIndex, int length) {
        int toIndex = fromIndex + length;
        boolean isEscapeCharacter = false;
        int nonVisibleCharacterCount = 0;
        for (int index = fromIndex; index < toIndex; ++index) {
            byte currentByte = message[index];
            if (isEscapeCharacter) {
                ++nonVisibleCharacterCount;
                if (AsciiCharacter.isLowercaseU(currentByte)) {
                    nonVisibleCharacterCount += 4;
                    index += 4;
                }
            } else {
                int codePointByteLength = Utf8Util.getCodePointByteLength(currentByte);
                if (codePointByteLength > 1) {
                    nonVisibleCharacterCount += codePointByteLength - 1;
                }
            }
            isEscapeCharacter = !isEscapeCharacter && AsciiCharacter.isEscapeCharacter(currentByte);
        }
        return nonVisibleCharacterCount;
    }
}

