/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.path;

import dev.blaauwendraad.masker.json.path.JsonPath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class JsonPathParser {
    private static final String ERROR_PREFIX = "Invalid jsonpath expression '%s'. ";

    @Nonnull
    public JsonPath parse(String literal) {
        if (!(literal.equals("$") || literal.startsWith("$.") || literal.startsWith("$["))) {
            throw new IllegalArgumentException(ERROR_PREFIX.formatted(literal) + "JSONPath must start with a root node identifier.");
        }
        if (literal.contains("'") || literal.contains("\\")) {
            throw new IllegalArgumentException(ERROR_PREFIX.formatted(literal) + "Escape characters are not supported.");
        }
        if (literal.contains("..")) {
            throw new IllegalArgumentException(ERROR_PREFIX.formatted(literal) + "Descendant segments are not supported.");
        }
        List<String> segments = this.parseSegments(literal);
        segments.forEach(segment -> this.validateSegment((String)segment, literal));
        return new JsonPath((String[])segments.toArray(String[]::new));
    }

    public JsonPath tryParse(String literal) {
        try {
            return this.parse(literal);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    private List<String> parseSegments(String literal) {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add("$");
        if (literal.equals("$")) {
            return segments;
        }
        StringBuilder segment = new StringBuilder();
        for (int i = 2; i < literal.length() - 1; ++i) {
            char symbol = literal.charAt(i);
            char nextSymbol = literal.charAt(i + 1);
            if (symbol == '.' || symbol == '[' && !segment.isEmpty()) {
                segments.add(segment.toString());
                segment = new StringBuilder();
                continue;
            }
            if (symbol == ']' && nextSymbol == '.' || symbol == ']' && nextSymbol == '[') {
                segments.add(segment.toString());
                segment = new StringBuilder();
                ++i;
                continue;
            }
            if (symbol == '[') continue;
            segment.append(symbol);
        }
        if (literal.charAt(literal.length() - 1) != ']' && literal.charAt(literal.length() - 1) != '.') {
            segment.append(literal.charAt(literal.length() - 1));
        }
        if (!segment.isEmpty() || literal.endsWith("[]")) {
            segments.add(segment.toString());
        }
        if (segments.size() > 1 && ((String)segments.get(segments.size() - 1)).equals("*") && !((String)segments.get(segments.size() - 2)).equals("*")) {
            throw new IllegalArgumentException(ERROR_PREFIX.formatted(literal) + "A single leading wildcard is not allowed. Use '" + literal.substring(0, literal.length() - 2) + "' instead.");
        }
        return segments;
    }

    private void validateSegment(String segment, String literal) {
        if (this.isNumber(segment)) {
            throw new IllegalArgumentException(ERROR_PREFIX.formatted(literal) + "Numbers as key names are not supported.");
        }
        if (segment.startsWith("?")) {
            throw new IllegalArgumentException(ERROR_PREFIX.formatted(literal) + "Filter selectors are not supported.");
        }
        if (segment.contains(":")) {
            throw new IllegalArgumentException(ERROR_PREFIX.formatted(literal) + "Array slice selectors are not supported.");
        }
        if (segment.contains("(")) {
            throw new IllegalArgumentException(ERROR_PREFIX.formatted(literal) + "Function extensions are not supported.");
        }
    }

    private boolean isNumber(String segment) {
        try {
            Long.parseLong(segment);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public void checkAmbiguity(Set<JsonPath> jsonPaths) {
        List<JsonPath> jsonPathList = jsonPaths.stream().sorted(Comparator.comparing(JsonPath::toString)).toList();
        block0: for (int i = 1; i < jsonPathList.size(); ++i) {
            JsonPath current = jsonPathList.get(i - 1);
            JsonPath next = jsonPathList.get(i);
            for (int j = 0; j < current.segments().length; ++j) {
                if (!current.segments()[j].equals(next.segments()[j])) {
                    if (!current.segments()[j].equals("*") && !next.segments()[j].equals("*")) continue block0;
                    throw new IllegalArgumentException(String.format("Ambiguous jsonpath keys. '%s' and '%s' combination is not supported.", current, next));
                }
                if (j != current.segments().length - 1) continue;
                throw new IllegalArgumentException(String.format("Ambiguous jsonpath keys. '%s' and '%s' combination is not supported.", current, next));
            }
        }
    }
}

