/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.config;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.CheckForNull;

public final class KeyMaskingConfig {
    @CheckForNull
    private final byte[] maskStringsWith;
    @CheckForNull
    private final byte[] maskStringCharactersWith;
    @CheckForNull
    private final byte[] maskNumbersWith;
    @CheckForNull
    private final byte[] maskNumberDigitsWith;
    @CheckForNull
    private final byte[] maskBooleansWith;

    KeyMaskingConfig(Builder builder) {
        if (builder.maskStringsWith != null) {
            this.maskStringsWith = ("\"" + builder.maskStringsWith + "\"").getBytes(StandardCharsets.UTF_8);
            this.maskStringCharactersWith = null;
        } else if (builder.maskStringCharactersWith != null) {
            this.maskStringsWith = null;
            this.maskStringCharactersWith = builder.maskStringCharactersWith.getBytes(StandardCharsets.UTF_8);
        } else {
            this.maskStringsWith = "\"***\"".getBytes(StandardCharsets.UTF_8);
            this.maskStringCharactersWith = null;
        }
        if (builder.maskNumbersWithString != null) {
            this.maskNumbersWith = ("\"" + builder.maskNumbersWithString + "\"").getBytes(StandardCharsets.UTF_8);
            this.maskNumberDigitsWith = null;
        } else if (builder.maskNumbersWith != null) {
            this.maskNumbersWith = builder.maskNumbersWith.toString().getBytes(StandardCharsets.UTF_8);
            this.maskNumberDigitsWith = null;
        } else if (builder.maskNumberDigitsWith != null) {
            this.maskNumbersWith = null;
            this.maskNumberDigitsWith = builder.maskNumberDigitsWith.toString().getBytes(StandardCharsets.UTF_8);
        } else if (builder.disableNumberMasking != null && builder.disableNumberMasking.booleanValue()) {
            this.maskNumbersWith = null;
            this.maskNumberDigitsWith = null;
        } else {
            this.maskNumbersWith = "\"###\"".getBytes(StandardCharsets.UTF_8);
            this.maskNumberDigitsWith = null;
        }
        this.maskBooleansWith = builder.maskBooleansWithString != null ? ("\"" + builder.maskBooleansWithString + "\"").getBytes(StandardCharsets.UTF_8) : (builder.maskBooleansWith != null ? builder.maskBooleansWith.toString().getBytes(StandardCharsets.UTF_8) : (byte[])(builder.disableBooleanMasking != null && builder.disableBooleanMasking != false ? null : "\"&&&\"".getBytes(StandardCharsets.UTF_8)));
    }

    public static Builder builder() {
        return new Builder();
    }

    @CheckForNull
    public byte[] getMaskStringsWith() {
        return this.maskStringsWith;
    }

    @CheckForNull
    public byte[] getMaskStringCharactersWith() {
        return this.maskStringCharactersWith;
    }

    public boolean isDisableNumberMasking() {
        return this.maskNumbersWith == null && this.maskNumberDigitsWith == null;
    }

    @CheckForNull
    public byte[] getMaskNumbersWith() {
        return this.maskNumbersWith;
    }

    @CheckForNull
    public byte[] getMaskNumberDigitsWith() {
        return this.maskNumberDigitsWith;
    }

    public boolean isDisableBooleanMasking() {
        return this.maskBooleansWith == null;
    }

    @CheckForNull
    public byte[] getMaskBooleansWith() {
        return this.maskBooleansWith;
    }

    public String toString() {
        return "KeyMaskingConfig{maskStringsWith='" + this.bytesToString(this.maskStringsWith) + "', maskStringCharactersWith='" + this.bytesToString(this.maskStringCharactersWith) + "', maskNumbersWith=" + this.bytesToString(this.maskNumbersWith) + ", maskNumberDigitsWith=" + this.bytesToString(this.maskNumberDigitsWith) + ", maskBooleansWith=" + this.bytesToString(this.maskBooleansWith) + "}";
    }

    private String bytesToString(@CheckForNull byte[] bytes) {
        return bytes != null ? new String(bytes, StandardCharsets.UTF_8) : null;
    }

    public static class Builder {
        private String maskStringsWith;
        private String maskStringCharactersWith;
        private Boolean disableNumberMasking;
        private String maskNumbersWithString;
        private Integer maskNumbersWith;
        private Integer maskNumberDigitsWith;
        private Boolean disableBooleanMasking;
        private String maskBooleansWithString;
        private Boolean maskBooleansWith;

        private Builder() {
        }

        public Builder maskStringsWith(String value) {
            if (this.maskStringsWith != null) {
                throw new IllegalArgumentException("'maskStringsWith(String)' was already set");
            }
            this.checkMutuallyExclusiveStringMaskingOptions();
            this.maskStringsWith = value;
            return this;
        }

        public Builder maskStringCharactersWith(String value) {
            if (this.maskStringCharactersWith != null) {
                throw new IllegalArgumentException("'maskStringCharactersWith(String)' was already set");
            }
            this.checkMutuallyExclusiveStringMaskingOptions();
            this.maskStringCharactersWith = value;
            return this;
        }

        public Builder disableNumberMasking() {
            if (this.disableNumberMasking != null) {
                throw new IllegalArgumentException("'disableNumberMasking()' was already set");
            }
            this.checkMutuallyExclusiveNumberMaskingOptions();
            this.disableNumberMasking = true;
            return this;
        }

        public Builder maskNumbersWith(String value) {
            if (this.maskNumbersWithString != null) {
                throw new IllegalArgumentException("'maskNumbersWith(String)' was already set");
            }
            this.checkMutuallyExclusiveNumberMaskingOptions();
            this.maskNumbersWithString = Objects.requireNonNull(value);
            return this;
        }

        public Builder maskNumbersWith(int value) {
            if (this.maskNumbersWith != null) {
                throw new IllegalArgumentException("'maskNumbersWith(int)' was already set");
            }
            this.checkMutuallyExclusiveNumberMaskingOptions();
            this.maskNumbersWith = value;
            return this;
        }

        public Builder maskNumberDigitsWith(int digit) {
            if (this.maskNumberDigitsWith != null) {
                throw new IllegalArgumentException("'maskNumberDigitsWith(int)' was already set");
            }
            this.checkMutuallyExclusiveNumberMaskingOptions();
            if (digit < 1 || digit > 9) {
                throw new IllegalArgumentException("Masking digit must be between 1 and 9 to avoid leading zeroes");
            }
            this.maskNumberDigitsWith = digit;
            return this;
        }

        public Builder disableBooleanMasking() {
            if (this.disableBooleanMasking != null) {
                throw new IllegalArgumentException("'disableBooleanMasking()' was already set");
            }
            this.checkMutuallyExclusiveBooleanMaskingOptions();
            this.disableBooleanMasking = true;
            return this;
        }

        public Builder maskBooleansWith(String value) {
            if (this.maskBooleansWithString != null) {
                throw new IllegalArgumentException("'maskBooleansWith(String)' was already set");
            }
            this.checkMutuallyExclusiveBooleanMaskingOptions();
            this.maskBooleansWithString = Objects.requireNonNull(value);
            return this;
        }

        public Builder maskBooleansWith(boolean value) {
            if (this.maskBooleansWith != null) {
                throw new IllegalArgumentException("'maskBooleansWith(boolean)' was already set");
            }
            this.checkMutuallyExclusiveBooleanMaskingOptions();
            this.maskBooleansWith = value;
            return this;
        }

        public KeyMaskingConfig build() {
            return new KeyMaskingConfig(this);
        }

        private void checkMutuallyExclusiveStringMaskingOptions() {
            if (this.maskStringsWith != null || this.maskStringCharactersWith != null) {
                throw new IllegalArgumentException("'maskStringsWith(String)' and 'maskStringCharactersWith(String)' are mutually exclusive");
            }
        }

        private void checkMutuallyExclusiveNumberMaskingOptions() {
            if (this.disableNumberMasking != null || this.maskNumbersWith != null || this.maskNumbersWithString != null || this.maskNumberDigitsWith != null) {
                throw new IllegalArgumentException("'disableNumberMasking()', 'maskNumbersWith(int)', 'maskNumbersWith(String)' and 'maskNumberDigitsWith(int)' are mutually exclusive");
            }
        }

        private void checkMutuallyExclusiveBooleanMaskingOptions() {
            if (this.disableBooleanMasking != null || this.maskBooleansWith != null || this.maskBooleansWithString != null) {
                throw new IllegalArgumentException("'disableBooleanMasking()', 'maskBooleansWith(boolean)' and 'maskBooleansWith(String)' are mutually exclusive");
            }
        }
    }
}

