/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.json.JsonPathNode;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

final class MaskingState {
    private final byte[] message;
    private int currentIndex = 0;
    private final List<ReplacementOperation> replacementOperations = new ArrayList<ReplacementOperation>();
    private int replacementOperationsTotalDifference = 0;
    private final Deque<JsonPathNode> currentJsonPath;

    public MaskingState(byte[] message, boolean trackJsonPath) {
        this.message = message;
        this.currentJsonPath = trackJsonPath ? new ArrayDeque<JsonPathNode>() : null;
    }

    public void incrementCurrentIndex() {
        ++this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public byte byteAtCurrentIndex() {
        return this.message[this.currentIndex];
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void replaceTargetValueWith(int startIndex, int length, byte[] mask, int maskRepeat) {
        ReplacementOperation replacementOperation = new ReplacementOperation(startIndex, length, mask, maskRepeat);
        this.replacementOperations.add(replacementOperation);
        this.replacementOperationsTotalDifference += replacementOperation.difference();
    }

    public byte[] flushReplacementOperations() {
        if (this.replacementOperations.isEmpty()) {
            return this.message;
        }
        byte[] newMessage = new byte[this.message.length + this.replacementOperationsTotalDifference];
        int index = 0;
        int offset = 0;
        for (ReplacementOperation replacementOperation : this.replacementOperations) {
            System.arraycopy(this.message, index, newMessage, index + offset, replacementOperation.startIndex - index);
            int length = replacementOperation.mask.length;
            for (int i = 0; i < replacementOperation.maskRepeat; ++i) {
                System.arraycopy(replacementOperation.mask, 0, newMessage, replacementOperation.startIndex + offset + i * length, length);
            }
            index = replacementOperation.startIndex + replacementOperation.length;
            offset += replacementOperation.difference();
        }
        System.arraycopy(this.message, index, newMessage, index + offset, this.message.length - index);
        this.currentIndex = Integer.MAX_VALUE;
        return newMessage;
    }

    boolean jsonPathEnabled() {
        return this.currentJsonPath != null;
    }

    void expandCurrentJsonPath(int start, int offset) {
        if (this.currentJsonPath != null) {
            this.currentJsonPath.push(new JsonPathNode.Node(start, offset));
        }
    }

    void expandCurrentJsonPathWithArray() {
        if (this.currentJsonPath != null) {
            this.currentJsonPath.push(new JsonPathNode.Array());
        }
    }

    void backtrackCurrentJsonPath() {
        if (this.currentJsonPath != null) {
            this.currentJsonPath.pop();
        }
    }

    Iterator<JsonPathNode> getCurrentJsonPath() {
        if (this.currentJsonPath != null) {
            return this.currentJsonPath.descendingIterator();
        }
        return Collections.emptyIterator();
    }

    public String toString() {
        return "current: '" + (Serializable)(this.currentIndex == this.message.length ? "<end of json>" : Character.valueOf((char)this.message[this.currentIndex])) + "', before: '" + new String(this.message, Math.max(0, this.currentIndex - 10), Math.min(10, this.currentIndex)) + "', after: '" + new String(this.message, this.currentIndex, Math.min(10, this.message.length - this.currentIndex)) + "'";
    }

    private record ReplacementOperation(int startIndex, int length, byte[] mask, int maskRepeat) {
        public int difference() {
            return this.mask.length * this.maskRepeat - this.length;
        }
    }
}

