/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.json.JsonMasker;
import dev.blaauwendraad.masker.json.KeyMatcher;
import dev.blaauwendraad.masker.json.MaskingState;
import dev.blaauwendraad.masker.json.config.JsonMaskingConfig;
import dev.blaauwendraad.masker.json.config.KeyMaskingConfig;
import dev.blaauwendraad.masker.json.util.AsciiCharacter;
import dev.blaauwendraad.masker.json.util.AsciiJsonUtil;
import dev.blaauwendraad.masker.json.util.Utf8Util;
import java.util.Collections;
import javax.annotation.CheckForNull;

public final class KeyContainsMasker
implements JsonMasker {
    private final KeyMatcher keyMatcher;
    private final JsonMaskingConfig maskingConfig;

    public KeyContainsMasker(JsonMaskingConfig maskingConfig) {
        this.maskingConfig = maskingConfig;
        this.keyMatcher = new KeyMatcher(maskingConfig);
    }

    @Override
    public byte[] mask(byte[] input) {
        KeyMaskingConfig keyMaskingConfig;
        MaskingState maskingState = new MaskingState(input, !this.maskingConfig.getTargetJsonPaths().isEmpty());
        KeyMaskingConfig keyMaskingConfig2 = keyMaskingConfig = this.maskingConfig.isInAllowMode() ? this.maskingConfig.getDefaultConfig() : null;
        if (maskingState.jsonPathEnabled()) {
            keyMaskingConfig = this.keyMatcher.getMaskConfigIfMatched(maskingState.getMessage(), -1, -1, Collections.emptyIterator());
        }
        this.visitValue(maskingState, keyMaskingConfig);
        return maskingState.flushReplacementOperations();
    }

    private void visitValue(MaskingState maskingState, @CheckForNull KeyMaskingConfig keyMaskingConfig) {
        KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
        switch (maskingState.byteAtCurrentIndex()) {
            case 91: {
                this.visitArray(maskingState, keyMaskingConfig);
                break;
            }
            case 123: {
                this.visitObject(maskingState, keyMaskingConfig);
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (keyMaskingConfig != null && !keyMaskingConfig.isDisableNumberMasking()) {
                    this.maskNumber(maskingState, keyMaskingConfig);
                    break;
                }
                KeyContainsMasker.stepOverNumericValue(maskingState);
                break;
            }
            case 34: {
                if (keyMaskingConfig != null) {
                    this.maskString(maskingState, keyMaskingConfig);
                    break;
                }
                KeyContainsMasker.stepOverStringValue(maskingState);
                break;
            }
            case 116: {
                if (keyMaskingConfig != null && !keyMaskingConfig.isDisableBooleanMasking()) {
                    this.maskBoolean(maskingState, keyMaskingConfig);
                    break;
                }
                maskingState.setCurrentIndex(maskingState.currentIndex() + 4);
                break;
            }
            case 102: {
                if (keyMaskingConfig != null && !keyMaskingConfig.isDisableBooleanMasking()) {
                    this.maskBoolean(maskingState, keyMaskingConfig);
                    break;
                }
                maskingState.setCurrentIndex(maskingState.currentIndex() + 5);
                break;
            }
            case 110: {
                maskingState.setCurrentIndex(maskingState.currentIndex() + 4);
            }
        }
    }

    private void visitArray(MaskingState maskingState, @CheckForNull KeyMaskingConfig keyMaskingConfig) {
        maskingState.expandCurrentJsonPathWithArray();
        maskingState.incrementCurrentIndex();
        while (!AsciiCharacter.isSquareBracketClose(maskingState.byteAtCurrentIndex())) {
            this.visitValue(maskingState, keyMaskingConfig);
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            if (!AsciiCharacter.isComma(maskingState.byteAtCurrentIndex())) continue;
            maskingState.incrementCurrentIndex();
        }
        maskingState.incrementCurrentIndex();
        maskingState.backtrackCurrentJsonPath();
    }

    private void visitObject(MaskingState maskingState, @CheckForNull KeyMaskingConfig parentKeyMaskingConfig) {
        maskingState.incrementCurrentIndex();
        KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
        while (!AsciiCharacter.isCurlyBracketClose(maskingState.byteAtCurrentIndex())) {
            boolean valueAllowed;
            int openingQuoteIndex = maskingState.currentIndex();
            KeyContainsMasker.stepOverStringValue(maskingState);
            int afterClosingQuoteIndex = maskingState.currentIndex();
            int keyLength = afterClosingQuoteIndex - openingQuoteIndex - 2;
            maskingState.expandCurrentJsonPath(openingQuoteIndex + 1, keyLength);
            KeyMaskingConfig keyMaskingConfig = this.keyMatcher.getMaskConfigIfMatched(maskingState.getMessage(), openingQuoteIndex + 1, keyLength, maskingState.getCurrentJsonPath());
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            maskingState.incrementCurrentIndex();
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            boolean bl = valueAllowed = this.maskingConfig.isInAllowMode() && keyMaskingConfig == null;
            if (valueAllowed) {
                KeyContainsMasker.stepOverValue(maskingState);
            } else {
                if (parentKeyMaskingConfig != null && (keyMaskingConfig == null || keyMaskingConfig == this.maskingConfig.getDefaultConfig())) {
                    keyMaskingConfig = parentKeyMaskingConfig;
                }
                this.visitValue(maskingState, keyMaskingConfig);
            }
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            if (AsciiCharacter.isComma(maskingState.byteAtCurrentIndex())) {
                maskingState.incrementCurrentIndex();
            }
            KeyContainsMasker.stepOverWhitespaceCharacters(maskingState);
            maskingState.backtrackCurrentJsonPath();
        }
        maskingState.incrementCurrentIndex();
    }

    private void maskString(MaskingState maskingState, KeyMaskingConfig keyMaskingConfig) {
        int valueStartIndex = maskingState.currentIndex();
        KeyContainsMasker.stepOverStringValue(maskingState);
        int targetValueLength = maskingState.currentIndex() - valueStartIndex;
        if (keyMaskingConfig.getMaskStringsWith() != null) {
            maskingState.replaceTargetValueWith(valueStartIndex, targetValueLength, keyMaskingConfig.getMaskStringsWith(), 1);
        } else if (keyMaskingConfig.getMaskStringCharactersWith() != null) {
            int nonVisibleCharacters = Utf8Util.countNonVisibleCharacters(maskingState.getMessage(), ++valueStartIndex, targetValueLength -= 2);
            maskingState.replaceTargetValueWith(valueStartIndex, targetValueLength, keyMaskingConfig.getMaskStringCharactersWith(), targetValueLength - nonVisibleCharacters);
        } else {
            throw new IllegalStateException("Invalid string masking configuration");
        }
    }

    private void maskNumber(MaskingState maskingState, KeyMaskingConfig keyMaskingConfig) {
        int targetValueStartIndex = maskingState.currentIndex();
        KeyContainsMasker.stepOverNumericValue(maskingState);
        int targetValueLength = maskingState.currentIndex() - targetValueStartIndex;
        if (keyMaskingConfig.getMaskNumbersWith() != null) {
            maskingState.replaceTargetValueWith(targetValueStartIndex, targetValueLength, keyMaskingConfig.getMaskNumbersWith(), 1);
        } else if (keyMaskingConfig.getMaskNumberDigitsWith() != null) {
            maskingState.replaceTargetValueWith(targetValueStartIndex, targetValueLength, keyMaskingConfig.getMaskNumberDigitsWith(), targetValueLength);
        } else {
            throw new IllegalStateException("Invalid number masking configuration");
        }
    }

    private void maskBoolean(MaskingState maskingState, KeyMaskingConfig keyMaskingConfig) {
        int targetValueLength;
        int n = targetValueLength = AsciiCharacter.isLowercaseT(maskingState.byteAtCurrentIndex()) ? 4 : 5;
        if (keyMaskingConfig.getMaskBooleansWith() == null) {
            throw new IllegalStateException("Invalid boolean masking configuration");
        }
        maskingState.replaceTargetValueWith(maskingState.currentIndex(), targetValueLength, keyMaskingConfig.getMaskBooleansWith(), 1);
        maskingState.setCurrentIndex(maskingState.currentIndex() + targetValueLength);
    }

    private static void stepOverValue(MaskingState maskingState) {
        switch (maskingState.byteAtCurrentIndex()) {
            case 34: {
                KeyContainsMasker.stepOverStringValue(maskingState);
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                KeyContainsMasker.stepOverNumericValue(maskingState);
                break;
            }
            case 110: 
            case 116: {
                maskingState.setCurrentIndex(maskingState.currentIndex() + 4);
                break;
            }
            case 102: {
                maskingState.setCurrentIndex(maskingState.currentIndex() + 5);
                break;
            }
            case 123: {
                KeyContainsMasker.stepOverObject(maskingState);
                break;
            }
            case 91: {
                KeyContainsMasker.stepOverArray(maskingState);
            }
        }
    }

    private static void stepOverWhitespaceCharacters(MaskingState maskingState) {
        while (AsciiJsonUtil.isWhiteSpace(maskingState.byteAtCurrentIndex())) {
            maskingState.incrementCurrentIndex();
        }
    }

    private static void stepOverNumericValue(MaskingState maskingState) {
        maskingState.incrementCurrentIndex();
        while (maskingState.currentIndex() < maskingState.getMessage().length && AsciiJsonUtil.isNumericCharacter(maskingState.byteAtCurrentIndex())) {
            maskingState.incrementCurrentIndex();
        }
    }

    private static void stepOverStringValue(MaskingState maskingState) {
        maskingState.incrementCurrentIndex();
        boolean isEscapeCharacter = false;
        while (!AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex()) || AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex()) && isEscapeCharacter) {
            isEscapeCharacter = !isEscapeCharacter && AsciiCharacter.isEscapeCharacter(maskingState.byteAtCurrentIndex());
            maskingState.incrementCurrentIndex();
        }
        maskingState.incrementCurrentIndex();
    }

    private static void stepOverObject(MaskingState maskingState) {
        maskingState.incrementCurrentIndex();
        int objectDepth = 1;
        while (objectDepth > 0) {
            if (AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex())) {
                KeyContainsMasker.stepOverStringValue(maskingState);
                continue;
            }
            if (AsciiCharacter.isCurlyBracketOpen(maskingState.byteAtCurrentIndex())) {
                ++objectDepth;
            } else if (AsciiCharacter.isCurlyBracketClose(maskingState.byteAtCurrentIndex())) {
                --objectDepth;
            }
            maskingState.incrementCurrentIndex();
        }
    }

    private static void stepOverArray(MaskingState maskingState) {
        maskingState.incrementCurrentIndex();
        int arrayDepth = 1;
        while (arrayDepth > 0) {
            if (AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex())) {
                KeyContainsMasker.stepOverStringValue(maskingState);
                continue;
            }
            if (AsciiCharacter.isSquareBracketOpen(maskingState.byteAtCurrentIndex())) {
                ++arrayDepth;
            } else if (AsciiCharacter.isSquareBracketClose(maskingState.byteAtCurrentIndex())) {
                --arrayDepth;
            }
            maskingState.incrementCurrentIndex();
        }
    }
}

