/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.config;

import dev.blaauwendraad.masker.json.config.JsonMaskerAlgorithmType;
import java.util.Set;

public class JsonMaskingConfig {
    private final Set<String> targetKeys;
    private final TargetKeyMode targetKeyMode;
    private final JsonMaskerAlgorithmType algorithmType = JsonMaskerAlgorithmType.KEYS_CONTAIN;
    private final int maskNumericValuesWith;
    private final int obfuscationLength;
    private final boolean caseSensitiveTargetKeys;

    JsonMaskingConfig(Builder builder) {
        this.obfuscationLength = builder.obfuscationLength;
        this.targetKeyMode = builder.targetKeyMode;
        this.targetKeys = builder.targets;
        if (this.targetKeyMode == TargetKeyMode.MASK && this.targetKeys.isEmpty()) {
            throw new IllegalArgumentException("Target keys set in mask mode must contain at least a single target key");
        }
        this.caseSensitiveTargetKeys = builder.caseSensitiveTargetKeys;
        this.maskNumericValuesWith = builder.maskNumberValuesWith;
        if (builder.maskNumberValuesWith == 0) {
            if (builder.obfuscationLength < 0 || builder.obfuscationLength > 1) {
                throw new IllegalArgumentException("Mask number values with can only be 0 if obfuscation length is 0 or 1 to preserve valid JSON");
            }
        } else if (builder.maskNumberValuesWith != -1 && (builder.maskNumberValuesWith < 1 || builder.maskNumberValuesWith > 9)) {
            throw new IllegalArgumentException("Mask number values with must be a digit between 1 and 9 when length obfuscation is disabled or obfuscation length is larger than than 0");
        }
        if (builder.obfuscationLength == 0 && builder.maskNumberValuesWith != 0 && builder.maskNumberValuesWith != -1) {
            throw new IllegalArgumentException("If obfuscation length is set to 0, numeric values are replaced with a single 0, so mask number values with must be 0 or number masking must be disabled");
        }
    }

    public static JsonMaskingConfig getDefault(Set<String> targets) {
        return JsonMaskingConfig.custom(targets, TargetKeyMode.MASK).build();
    }

    public static Builder custom(Set<String> targets, TargetKeyMode targetKeyMode) {
        return new Builder(targets, targetKeyMode);
    }

    public JsonMaskerAlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    public int getMaskNumericValuesWith() {
        return this.maskNumericValuesWith;
    }

    public boolean isNumberMaskingEnabled() {
        return this.maskNumericValuesWith != -1;
    }

    public TargetKeyMode getTargetKeyMode() {
        return this.targetKeyMode;
    }

    public Set<String> getTargetKeys() {
        return this.targetKeys;
    }

    public int getObfuscationLength() {
        return this.obfuscationLength;
    }

    public boolean isLengthObfuscationEnabled() {
        return this.obfuscationLength != -1;
    }

    public boolean caseSensitiveTargetKeys() {
        return this.caseSensitiveTargetKeys;
    }

    public boolean isInAllowMode() {
        return this.targetKeyMode == TargetKeyMode.ALLOW;
    }

    public boolean isInMaskMode() {
        return this.targetKeyMode == TargetKeyMode.MASK;
    }

    public String toString() {
        return "JsonMaskingConfig{targetKeys=" + this.targetKeys + ", targetKeyMode=" + this.targetKeyMode + ", algorithmType=" + this.algorithmType + ", maskNumericValuesWith=" + this.maskNumericValuesWith + ", obfuscationLength=" + this.obfuscationLength + ", caseSensitiveTargetKeys=" + this.caseSensitiveTargetKeys + "}";
    }

    public static class Builder {
        private final Set<String> targets;
        private final TargetKeyMode targetKeyMode;
        private int maskNumberValuesWith;
        private JsonMaskerAlgorithmType algorithmTypeOverride;
        private int obfuscationLength;
        private boolean caseSensitiveTargetKeys;

        public Builder(Set<String> targets, TargetKeyMode targetKeyMode) {
            this.targets = targets;
            this.targetKeyMode = targetKeyMode;
            this.maskNumberValuesWith = -1;
            this.obfuscationLength = -1;
            this.caseSensitiveTargetKeys = false;
        }

        public Builder maskNumericValuesWith(int maskNumericValuesWith) {
            this.maskNumberValuesWith = maskNumericValuesWith;
            return this;
        }

        public Builder obfuscationLength(int obfuscationLength) {
            this.obfuscationLength = obfuscationLength;
            return this;
        }

        public Builder caseSensitiveTargetKeys() {
            this.caseSensitiveTargetKeys = true;
            return this;
        }

        public JsonMaskingConfig build() {
            return new JsonMaskingConfig(this);
        }
    }

    public static enum TargetKeyMode {
        ALLOW,
        MASK;

    }
}

