/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.json.ByteTrie;
import dev.blaauwendraad.masker.json.JsonMasker;
import dev.blaauwendraad.masker.json.MaskingState;
import dev.blaauwendraad.masker.json.config.JsonMaskingConfig;
import dev.blaauwendraad.masker.json.util.AsciiCharacter;
import dev.blaauwendraad.masker.json.util.AsciiJsonUtil;
import dev.blaauwendraad.masker.json.util.FixedLengthTargetValueMaskUtil;
import dev.blaauwendraad.masker.json.util.Utf8Util;

public final class KeyContainsMasker
implements JsonMasker {
    private static final int MIN_OFFSET_JSON_KEY_QUOTE = 3;
    private static final int MIN_MASKABLE_JSON_LENGTH = 7;
    private final ByteTrie targetKeysTrie;
    private final JsonMaskingConfig maskingConfig;

    public KeyContainsMasker(JsonMaskingConfig maskingConfig) {
        this.maskingConfig = maskingConfig;
        this.targetKeysTrie = new ByteTrie(!maskingConfig.caseSensitiveTargetKeys());
        for (String key : maskingConfig.getTargetKeys()) {
            this.targetKeysTrie.insert(key);
        }
    }

    @Override
    public byte[] mask(byte[] input) {
        if (!KeyContainsMasker.isObjectOrArray(input) || input.length < 7) {
            return input;
        }
        MaskingState maskingState = new MaskingState(input, 1);
        block0: while (maskingState.currentIndex() < maskingState.messageLength() - 3) {
            while (!KeyContainsMasker.currentByteIsUnescapedDoubleQuote(maskingState)) {
                if (maskingState.currentIndex() >= maskingState.messageLength() - 3 - 1) break block0;
                maskingState.incrementCurrentIndex();
            }
            int openingQuoteIndex = maskingState.currentIndex();
            maskingState.incrementCurrentIndex();
            while (!KeyContainsMasker.currentByteIsUnescapedDoubleQuote(maskingState) && maskingState.currentIndex() < maskingState.messageLength() - 1) {
                if (maskingState.currentIndex() >= maskingState.messageLength() - 3) break block0;
                maskingState.incrementCurrentIndex();
            }
            int closingQuoteIndex = maskingState.currentIndex();
            maskingState.incrementCurrentIndex();
            while (!AsciiCharacter.isColon(maskingState.byteAtCurrentIndex())) {
                if (!AsciiJsonUtil.isWhiteSpace(maskingState.byteAtCurrentIndex())) continue block0;
                maskingState.incrementCurrentIndex();
            }
            maskingState.incrementCurrentIndex();
            KeyContainsMasker.skipWhitespaceCharacters(maskingState);
            if (!this.isStartOfMaskableValue(maskingState)) continue;
            int keyLength = closingQuoteIndex - openingQuoteIndex - 1;
            boolean keyMatched = this.targetKeysTrie.search(maskingState.getMessage(), openingQuoteIndex + 1, keyLength);
            if (this.maskingConfig.isInAllowMode() && keyMatched) {
                KeyContainsMasker.skipAllValues(maskingState);
                continue;
            }
            if (this.maskingConfig.isInMaskMode() && !keyMatched) continue;
            if (AsciiJsonUtil.isArrayStart(maskingState.byteAtCurrentIndex())) {
                this.maskArrayValueInPlace(maskingState);
                continue;
            }
            if (AsciiJsonUtil.isObjectStart(maskingState.byteAtCurrentIndex())) {
                this.maskObjectValueInPlace(maskingState);
                continue;
            }
            if (this.maskingConfig.isNumberMaskingEnabled() && AsciiJsonUtil.isNumericCharacter(maskingState.byteAtCurrentIndex())) {
                this.maskNumberValueInPlace(maskingState);
                continue;
            }
            this.maskStringValueInPlace(maskingState);
        }
        return maskingState.getMessage();
    }

    private static boolean currentByteIsUnescapedDoubleQuote(MaskingState maskingState) {
        return AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex()) && !AsciiCharacter.isEscapeCharacter(maskingState.byteAtCurrentIndexMinusOne());
    }

    private static boolean isObjectOrArray(byte[] input) {
        return AsciiCharacter.CURLY_BRACKET_OPEN.getAsciiByteValue() == input[0] || AsciiCharacter.SQUARE_BRACKET_OPEN.getAsciiByteValue() == input[0];
    }

    private static void skipWhitespaceCharacters(MaskingState maskingState) {
        while (AsciiJsonUtil.isWhiteSpace(maskingState.byteAtCurrentIndex())) {
            maskingState.incrementCurrentIndex();
        }
    }

    private boolean isStartOfMaskableValue(MaskingState maskingState) {
        return AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex()) || AsciiJsonUtil.isArrayStart(maskingState.byteAtCurrentIndex()) || this.maskingConfig.isNumberMaskingEnabled() && AsciiJsonUtil.isFirstNumberChar(maskingState.byteAtCurrentIndex()) || AsciiJsonUtil.isObjectStart(maskingState.byteAtCurrentIndex());
    }

    private void maskStringValueInPlace(MaskingState maskingState) {
        maskingState.incrementCurrentIndex();
        int targetValueLength = 0;
        int noOfEscapeCharacters = 0;
        int additionalBytesForEncoding = 0;
        boolean isEscapeCharacter = false;
        boolean previousCharacterCountedAsEscapeCharacter = false;
        while (!AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex()) || AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex()) && isEscapeCharacter) {
            if (Utf8Util.getCodePointByteLength(maskingState.byteAtCurrentIndex()) > 1) {
                additionalBytesForEncoding += Utf8Util.getCodePointByteLength(maskingState.byteAtCurrentIndex()) - 1;
            }
            boolean bl = isEscapeCharacter = AsciiCharacter.isEscapeCharacter(maskingState.byteAtCurrentIndex()) && !previousCharacterCountedAsEscapeCharacter;
            if (isEscapeCharacter) {
                ++noOfEscapeCharacters;
                previousCharacterCountedAsEscapeCharacter = true;
            } else {
                if (previousCharacterCountedAsEscapeCharacter && AsciiCharacter.isLowercaseU(maskingState.byteAtCurrentIndex())) {
                    additionalBytesForEncoding += 4;
                }
                previousCharacterCountedAsEscapeCharacter = false;
            }
            maskingState.setByteAtCurrentIndex(AsciiCharacter.ASTERISK.getAsciiByteValue());
            ++targetValueLength;
            maskingState.incrementCurrentIndex();
        }
        int obfuscationLength = this.maskingConfig.getObfuscationLength();
        if (this.maskingConfig.isLengthObfuscationEnabled() && obfuscationLength != targetValueLength) {
            FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthAsteriskMask(maskingState, obfuscationLength, targetValueLength);
            maskingState.setCurrentIndex(maskingState.currentIndex() - (targetValueLength - obfuscationLength));
        } else if (!(this.maskingConfig.isLengthObfuscationEnabled() || noOfEscapeCharacters <= 0 && additionalBytesForEncoding <= 0)) {
            int actualStringLength = targetValueLength - noOfEscapeCharacters - additionalBytesForEncoding;
            FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthAsteriskMask(maskingState, actualStringLength, targetValueLength);
            maskingState.setCurrentIndex(maskingState.currentIndex() - noOfEscapeCharacters - additionalBytesForEncoding);
        }
        maskingState.incrementCurrentIndex();
    }

    private void maskArrayValueInPlace(MaskingState maskingState) {
        int arrayDepth = 1;
        maskingState.incrementCurrentIndex();
        KeyContainsMasker.skipWhitespaceCharacters(maskingState);
        while (arrayDepth > 0) {
            if (AsciiCharacter.isSquareBracketOpen(maskingState.byteAtCurrentIndex())) {
                ++arrayDepth;
                maskingState.incrementCurrentIndex();
            } else if (AsciiCharacter.isSquareBracketClose(maskingState.byteAtCurrentIndex())) {
                --arrayDepth;
                maskingState.incrementCurrentIndex();
            } else if (AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex())) {
                this.maskStringValueInPlace(maskingState);
            } else if (AsciiJsonUtil.isFirstNumberChar(maskingState.byteAtCurrentIndex()) && this.maskingConfig.isNumberMaskingEnabled()) {
                this.maskNumberValueInPlace(maskingState);
            } else if (AsciiJsonUtil.isObjectStart(maskingState.byteAtCurrentIndex())) {
                this.maskObjectValueInPlace(maskingState);
            } else {
                KeyContainsMasker.skipAllValues(maskingState);
            }
            KeyContainsMasker.skipWhitespaceCharacters(maskingState);
            if (AsciiCharacter.isComma(maskingState.byteAtCurrentIndex())) {
                maskingState.incrementCurrentIndex();
            }
            KeyContainsMasker.skipWhitespaceCharacters(maskingState);
        }
    }

    private void maskObjectValueInPlace(MaskingState maskingState) {
        maskingState.incrementCurrentIndex();
        KeyContainsMasker.skipWhitespaceCharacters(maskingState);
        while (!AsciiCharacter.isCurlyBracketClose(maskingState.byteAtCurrentIndex())) {
            boolean valueMustBeMasked = true;
            if (this.maskingConfig.isInAllowMode()) {
                int openingQuoteIndex = maskingState.currentIndex();
                maskingState.incrementCurrentIndex();
                while (!KeyContainsMasker.currentByteIsUnescapedDoubleQuote(maskingState)) {
                    maskingState.incrementCurrentIndex();
                }
                int closingQuoteIndex = maskingState.currentIndex();
                int keyLength = closingQuoteIndex - openingQuoteIndex - 1;
                valueMustBeMasked = !this.targetKeysTrie.search(maskingState.getMessage(), openingQuoteIndex + 1, keyLength);
            } else {
                maskingState.incrementCurrentIndex();
                while (!KeyContainsMasker.currentByteIsUnescapedDoubleQuote(maskingState)) {
                    maskingState.incrementCurrentIndex();
                }
            }
            maskingState.incrementCurrentIndex();
            KeyContainsMasker.skipWhitespaceCharacters(maskingState);
            maskingState.incrementCurrentIndex();
            KeyContainsMasker.skipWhitespaceCharacters(maskingState);
            if (valueMustBeMasked) {
                if (AsciiCharacter.isSquareBracketOpen(maskingState.byteAtCurrentIndex())) {
                    this.maskArrayValueInPlace(maskingState);
                } else if (AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex())) {
                    this.maskStringValueInPlace(maskingState);
                } else if (AsciiJsonUtil.isFirstNumberChar(maskingState.byteAtCurrentIndex()) && this.maskingConfig.isNumberMaskingEnabled()) {
                    this.maskNumberValueInPlace(maskingState);
                } else if (AsciiJsonUtil.isObjectStart(maskingState.byteAtCurrentIndex())) {
                    this.maskObjectValueInPlace(maskingState);
                } else {
                    while (!AsciiCharacter.isComma(maskingState.byteAtCurrentIndex()) && !AsciiCharacter.isCurlyBracketClose(maskingState.byteAtCurrentIndex())) {
                        maskingState.incrementCurrentIndex();
                    }
                }
            } else {
                KeyContainsMasker.skipAllValues(maskingState);
            }
            KeyContainsMasker.skipWhitespaceCharacters(maskingState);
            if (AsciiCharacter.isComma(maskingState.byteAtCurrentIndex())) {
                maskingState.incrementCurrentIndex();
            }
            KeyContainsMasker.skipWhitespaceCharacters(maskingState);
        }
        maskingState.incrementCurrentIndex();
    }

    private void maskNumberValueInPlace(MaskingState maskingState) {
        int obfuscationLength = this.maskingConfig.getObfuscationLength();
        int targetValueLength = 0;
        while (AsciiJsonUtil.isNumericCharacter(maskingState.byteAtCurrentIndex())) {
            ++targetValueLength;
            maskingState.setByteAtCurrentIndex(AsciiCharacter.toAsciiByteValue(this.maskingConfig.getMaskNumericValuesWith()));
            maskingState.incrementCurrentIndex();
        }
        if (this.maskingConfig.isLengthObfuscationEnabled() && obfuscationLength != targetValueLength) {
            if (obfuscationLength == 0) {
                FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthMask(maskingState, 1, targetValueLength, AsciiCharacter.toAsciiByteValue(this.maskingConfig.getMaskNumericValuesWith()));
                maskingState.setCurrentIndex(maskingState.currentIndex() - (targetValueLength - 1));
            } else {
                FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthMask(maskingState, obfuscationLength, targetValueLength, AsciiCharacter.toAsciiByteValue(this.maskingConfig.getMaskNumericValuesWith()));
                maskingState.setCurrentIndex(maskingState.currentIndex() - (targetValueLength - obfuscationLength));
            }
        }
    }

    private static void skipAllValues(MaskingState maskingState) {
        block12: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                if (!AsciiCharacter.isLowercaseN(maskingState.byteAtCurrentIndex()) && !AsciiCharacter.isLowercaseT(maskingState.byteAtCurrentIndex())) break block11;
                                maskingState.setCurrentIndex(maskingState.currentIndex() + 4);
                                break block12;
                            }
                            if (!AsciiCharacter.isLowercaseF(maskingState.byteAtCurrentIndex())) break block13;
                            maskingState.setCurrentIndex(maskingState.currentIndex() + 5);
                            break block12;
                        }
                        if (!AsciiCharacter.isDoubleQuote(maskingState.byteAtCurrentIndex())) break block14;
                        KeyContainsMasker.skipStringValue(maskingState);
                        break block12;
                    }
                    if (!AsciiJsonUtil.isFirstNumberChar(maskingState.byteAtCurrentIndex())) break block15;
                    while (AsciiJsonUtil.isNumericCharacter(maskingState.byteAtCurrentIndex())) {
                        maskingState.incrementCurrentIndex();
                    }
                    break block12;
                }
                if (!AsciiCharacter.isCurlyBracketOpen(maskingState.byteAtCurrentIndex())) break block16;
                maskingState.incrementCurrentIndex();
                int objectDepth = 1;
                while (objectDepth > 0) {
                    if (KeyContainsMasker.currentByteIsUnescapedDoubleQuote(maskingState)) {
                        KeyContainsMasker.skipStringValue(maskingState);
                        continue;
                    }
                    if (AsciiCharacter.isCurlyBracketOpen(maskingState.byteAtCurrentIndex())) {
                        ++objectDepth;
                    } else if (AsciiCharacter.isCurlyBracketClose(maskingState.byteAtCurrentIndex())) {
                        --objectDepth;
                    }
                    maskingState.incrementCurrentIndex();
                }
                break block12;
            }
            if (!AsciiCharacter.isSquareBracketOpen(maskingState.byteAtCurrentIndex())) break block12;
            maskingState.incrementCurrentIndex();
            int arrayDepth = 1;
            while (arrayDepth > 0) {
                if (KeyContainsMasker.currentByteIsUnescapedDoubleQuote(maskingState)) {
                    KeyContainsMasker.skipStringValue(maskingState);
                    continue;
                }
                if (AsciiCharacter.isSquareBracketOpen(maskingState.byteAtCurrentIndex())) {
                    ++arrayDepth;
                } else if (AsciiCharacter.isSquareBracketClose(maskingState.byteAtCurrentIndex())) {
                    --arrayDepth;
                }
                maskingState.incrementCurrentIndex();
            }
        }
    }

    private static void skipStringValue(MaskingState maskingState) {
        maskingState.incrementCurrentIndex();
        while (!KeyContainsMasker.currentByteIsUnescapedDoubleQuote(maskingState)) {
            maskingState.incrementCurrentIndex();
        }
        maskingState.incrementCurrentIndex();
    }
}

