/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import java.nio.charset.StandardCharsets;

final class ByteTrie {
    private static final int MAX_BYTE_SIZE = 128;
    private final TrieNode root;
    private final boolean caseInsensitive;
    private final boolean[] knownByteLengths = new boolean[256];

    public ByteTrie(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        this.root = new TrieNode();
    }

    public void insert(String word) {
        byte[] bytes = word.getBytes(StandardCharsets.UTF_8);
        this.knownByteLengths[bytes.length] = true;
        byte[] lowerBytes = null;
        byte[] upperBytes = null;
        if (this.caseInsensitive) {
            lowerBytes = word.toLowerCase().getBytes(StandardCharsets.UTF_8);
            upperBytes = word.toUpperCase().getBytes(StandardCharsets.UTF_8);
            if (bytes.length != lowerBytes.length || bytes.length != upperBytes.length) {
                throw new IllegalArgumentException("Case insensitive trie does not support all characters");
            }
        }
        TrieNode node = this.root;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            TrieNode child = node.children[b + 128];
            if (child == null) {
                node.children[b + 128] = child = new TrieNode();
                if (this.caseInsensitive) {
                    node.children[lowerBytes[i] + 128] = child;
                    node.children[upperBytes[i] + 128] = child;
                }
            }
            node = child;
        }
        node.endOfWord = true;
    }

    public boolean search(byte[] bytes, int offset, int length) {
        if (!this.knownByteLengths[length]) {
            return false;
        }
        TrieNode node = this.root;
        for (int i = offset; i < offset + length; ++i) {
            byte b = bytes[i];
            node = node.children[b + 128];
            if (node != null) continue;
            return false;
        }
        return node.endOfWord;
    }

    private static class TrieNode {
        private final TrieNode[] children = new TrieNode[256];
        private boolean endOfWord = false;

        private TrieNode() {
        }
    }
}

