/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.path;

import dev.blaauwendraad.masker.json.path.JsonPath;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class JsonPathTreeNode {
    private final Map<String, JsonPathTreeNode> children;
    private boolean isLeafNode;

    public JsonPathTreeNode() {
        this.children = new HashMap<String, JsonPathTreeNode>();
        this.isLeafNode = false;
    }

    public JsonPathTreeNode(boolean isLeafNode) {
        this.children = new HashMap<String, JsonPathTreeNode>();
        this.isLeafNode = isLeafNode;
    }

    public JsonPathTreeNode(Map<String, JsonPathTreeNode> children, boolean isLeafNode) {
        this.children = children;
        this.isLeafNode = isLeafNode;
    }

    @Nonnull
    public static JsonPathTreeNode of(Set<JsonPath> jsonPaths) {
        boolean found;
        JsonPathTreeNode root = new JsonPathTreeNode();
        int depth = 0;
        do {
            found = false;
            for (JsonPath jsonPath : jsonPaths) {
                if (jsonPath.getPathComponents().length <= depth) continue;
                JsonPathTreeNode parent = JsonPathTreeNode.resolveParent(root, jsonPath.getPathComponents(), depth);
                JsonPathTreeNode node = parent.children.computeIfAbsent(jsonPath.getPathComponents()[depth], key -> new JsonPathTreeNode());
                node.isLeafNode = node.isLeafNode || jsonPath.getPathComponents().length == depth + 1;
                found = true;
            }
            ++depth;
        } while (found);
        return root;
    }

    private static JsonPathTreeNode resolveParent(JsonPathTreeNode root, String[] pathComponents, int depth) {
        for (int i = 0; i < depth; ++i) {
            root = root.children.get(pathComponents[i]);
        }
        return root;
    }

    public Map<String, JsonPathTreeNode> getChildren() {
        return this.children;
    }

    public boolean isLeafNode() {
        return this.isLeafNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPathTreeNode that = (JsonPathTreeNode)o;
        return this.isLeafNode == that.isLeafNode && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.isLeafNode);
    }
}

