/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.path;

import java.util.Arrays;
import javax.annotation.Nonnull;

public class JsonPath {
    private final String[] pathComponents;

    JsonPath(String[] pathComponents) {
        this.pathComponents = pathComponents;
    }

    @Nonnull
    public static JsonPath from(String jsonPathLiteral) {
        if (!jsonPathLiteral.startsWith("$.")) {
            throw new IllegalArgumentException("JSONPath literal must start with a \"$.\"");
        }
        if (jsonPathLiteral.length() < 3) {
            throw new IllegalArgumentException("JSONPath must contain at least one name selector");
        }
        if (jsonPathLiteral.charAt(jsonPathLiteral.length() - 1) == '.') {
            throw new IllegalArgumentException("JSONPath cannot end with a component separator ('.')");
        }
        String jsonPathLiteralTmp = jsonPathLiteral.substring(2);
        return new JsonPath(jsonPathLiteralTmp.split("\\."));
    }

    public String[] getPathComponents() {
        return this.pathComponents;
    }

    public String toString() {
        return "$." + String.join((CharSequence)".", this.pathComponents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPath jsonPath = (JsonPath)o;
        return Arrays.equals(this.pathComponents, jsonPath.pathComponents);
    }

    public int hashCode() {
        return Arrays.hashCode(this.pathComponents);
    }
}

