/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json.config;

import dev.blaauwendraad.masker.json.config.JsonMaskerAlgorithmType;
import dev.blaauwendraad.masker.json.path.JsonPath;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonMaskingConfig {
    private final Set<String> targetKeys;
    private final TargetKeyMode targetKeyMode;
    private final Set<JsonPath> targetJsonPaths;
    private final JsonMaskerAlgorithmType algorithmType;
    private final int maskNumberValuesWith;
    private final int obfuscationLength;
    private final boolean caseSensitiveTargetKeys;

    JsonMaskingConfig(Builder builder) {
        Set<String> targets = builder.targets;
        this.targetKeyMode = builder.targetKeyMode;
        this.obfuscationLength = builder.obfuscationLength;
        if (builder.obfuscationLength == 0 && builder.maskNumberValuesWith != 0 && builder.maskNumberValuesWith != -1) {
            throw new IllegalArgumentException("If obfuscation length is set to 0, numeric values are replaced with a single 0, so mask number values with must be 0 or number masking must be disabled");
        }
        if (this.targetKeyMode == TargetKeyMode.MASK && targets.isEmpty()) {
            throw new IllegalArgumentException("Target keys set in mask mode must contain at least a single target key");
        }
        if (builder.maskNumberValuesWith == 0) {
            if (builder.obfuscationLength < 0 || builder.obfuscationLength > 1) {
                throw new IllegalArgumentException("Mask number values with can only be 0 if obfuscation length is 0 or 1 to preserve valid JSON");
            }
        } else if (builder.maskNumberValuesWith != -1 && (builder.maskNumberValuesWith < 1 || builder.maskNumberValuesWith > 9)) {
            throw new IllegalArgumentException("Mask number values with must be a digit between 1 and 9 when length obfuscation is disabled or obfuscation length is larger than than 0");
        }
        this.maskNumberValuesWith = builder.maskNumberValuesWith;
        this.caseSensitiveTargetKeys = builder.caseSensitiveTargetKeys;
        if (!this.caseSensitiveTargetKeys) {
            targets = targets.stream().map(String::toLowerCase).collect(Collectors.toSet());
        }
        Set<String> jsonPathLiterals = targets.stream().filter(t -> t.startsWith("$.")).collect(Collectors.toSet());
        this.algorithmType = builder.algorithmTypeOverride != null ? builder.algorithmTypeOverride : (!jsonPathLiterals.isEmpty() && builder.resolveJsonPaths ? JsonMaskerAlgorithmType.PATH_AWARE_KEYS_CONTAIN : (targets.size() > 1 ? JsonMaskerAlgorithmType.KEYS_CONTAIN : JsonMaskerAlgorithmType.SINGLE_TARGET_LOOP));
        switch (this.algorithmType) {
            case PATH_AWARE_KEYS_CONTAIN: {
                this.targetJsonPaths = this.resolveJsonPaths(jsonPathLiterals);
                targets.removeIf(jsonPathLiterals::contains);
                this.targetKeys = targets;
                break;
            }
            case KEYS_CONTAIN: 
            case SINGLE_TARGET_LOOP: {
                this.targetJsonPaths = Set.of();
                this.targetKeys = targets;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown JSON masking algorithm");
            }
        }
    }

    private Set<JsonPath> resolveJsonPaths(Set<String> targets) {
        return targets.stream().map(JsonPath::from).collect(Collectors.toSet());
    }

    public static JsonMaskingConfig getDefault(Set<String> targets) {
        return JsonMaskingConfig.custom(targets, TargetKeyMode.MASK).build();
    }

    public static Builder custom(Set<String> targets, TargetKeyMode targetKeyMode) {
        return new Builder(targets, targetKeyMode);
    }

    public JsonMaskerAlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    public int getMaskNumberValuesWith() {
        return this.maskNumberValuesWith;
    }

    public boolean isNumberMaskingEnabled() {
        return this.maskNumberValuesWith != -1;
    }

    public boolean isNumberMaskingDisabled() {
        return this.maskNumberValuesWith == -1;
    }

    public TargetKeyMode getTargetKeyMode() {
        return this.targetKeyMode;
    }

    public Set<String> getTargetKeys() {
        return this.targetKeys;
    }

    public Set<JsonPath> getTargetJsonPaths() {
        return this.targetJsonPaths;
    }

    public int getObfuscationLength() {
        return this.obfuscationLength;
    }

    public boolean isObfuscationEnabled() {
        return this.obfuscationLength != -1;
    }

    public boolean caseSensitiveTargetKeys() {
        return this.caseSensitiveTargetKeys;
    }

    public static class Builder {
        private final Set<String> targets;
        private final TargetKeyMode targetKeyMode;
        private int maskNumberValuesWith;
        private boolean resolveJsonPaths;
        private JsonMaskerAlgorithmType algorithmTypeOverride;
        private int obfuscationLength;
        private boolean caseSensitiveTargetKeys;

        public Builder(Set<String> targets, TargetKeyMode targetKeyMode) {
            this.targets = targets;
            this.targetKeyMode = targetKeyMode;
            this.maskNumberValuesWith = -1;
            this.resolveJsonPaths = true;
            this.obfuscationLength = -1;
            this.caseSensitiveTargetKeys = false;
        }

        public Builder maskNumberValuesWith(int maskNumberValuesWith) {
            this.maskNumberValuesWith = maskNumberValuesWith;
            return this;
        }

        public Builder algorithmTypeOverride(JsonMaskerAlgorithmType algorithmType) {
            this.algorithmTypeOverride = algorithmType;
            return this;
        }

        public Builder obfuscationLength(int obfuscationLength) {
            this.obfuscationLength = obfuscationLength;
            return this.self();
        }

        public Builder caseSensitiveTargetKeys() {
            this.caseSensitiveTargetKeys = true;
            return this.self();
        }

        public Builder disableJsonPathResolving() {
            this.resolveJsonPaths = false;
            return this;
        }

        public JsonMaskingConfig build() {
            return new JsonMaskingConfig(this);
        }

        protected Builder self() {
            return this;
        }
    }

    public static enum TargetKeyMode {
        ALLOW,
        MASK;

    }
}

