/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.AsciiCharacter;
import dev.blaauwendraad.masker.Utf8Util;
import dev.blaauwendraad.masker.json.AsciiJsonUtil;
import dev.blaauwendraad.masker.json.FixedLengthTargetValueMaskUtil;
import dev.blaauwendraad.masker.json.JsonMasker;
import dev.blaauwendraad.masker.json.config.JsonMaskingConfig;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SingleTargetMasker
implements JsonMasker {
    private final Set<String> quotedTargetKeys = new HashSet<String>();
    private final JsonMaskingConfig maskingConfig;

    public SingleTargetMasker(JsonMaskingConfig maskingConfig) {
        maskingConfig.getTargetKeys().forEach(t -> this.quotedTargetKeys.add("\"" + t + "\""));
        this.maskingConfig = maskingConfig;
    }

    static int indexOf(byte[] src, byte[] target) {
        for (int i = 0; i <= src.length - target.length; ++i) {
            boolean found = true;
            for (int j = 0; j < target.length; ++j) {
                if (src[i + j] == target[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    @Override
    public byte[] mask(byte[] message) {
        for (String targetKey : this.quotedTargetKeys) {
            message = this.mask(message, targetKey);
        }
        return message;
    }

    public byte[] mask(byte[] input, String targetKey) {
        byte[] outputBytes = input;
        int i = 0;
        int j = 0;
        block0: while (j < outputBytes.length - targetKey.getBytes().length - 2) {
            int startIndexOfTargetKey;
            byte[] inputSliceBytes = (j += i) == 0 ? outputBytes : Arrays.copyOfRange(outputBytes, j, outputBytes.length);
            if (!this.maskingConfig.caseSensitiveTargetKeys()) {
                inputSliceBytes = new String(inputSliceBytes, StandardCharsets.UTF_8).toLowerCase().getBytes(StandardCharsets.UTF_8);
            }
            if ((startIndexOfTargetKey = SingleTargetMasker.indexOf(inputSliceBytes, targetKey.getBytes(StandardCharsets.UTF_8))) == -1) break;
            for (i = startIndexOfTargetKey + targetKey.length(); i < inputSliceBytes.length; ++i) {
                if (AsciiJsonUtil.isWhiteSpace(inputSliceBytes[i])) continue;
                if (!AsciiCharacter.isColon(inputSliceBytes[i])) continue block0;
                break;
            }
            ++i;
            while (i < inputSliceBytes.length) {
                if (!AsciiJsonUtil.isWhiteSpace(inputSliceBytes[i])) {
                    int targetValueLength;
                    if (this.maskingConfig.isNumberMaskingEnabled() && AsciiJsonUtil.isFirstNumberChar(inputSliceBytes[i])) {
                        targetValueLength = 0;
                        while (AsciiJsonUtil.isNumericCharacter(inputSliceBytes[i])) {
                            outputBytes[i + j] = AsciiCharacter.toAsciiByteValue(this.maskingConfig.getMaskNumberValuesWith());
                            ++targetValueLength;
                            ++i;
                        }
                        int obfuscationLength = this.maskingConfig.getObfuscationLength();
                        if (!this.maskingConfig.isObfuscationEnabled() || obfuscationLength == targetValueLength) continue block0;
                        if (obfuscationLength == 0) {
                            outputBytes = FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthMask(outputBytes, i, 1, targetValueLength, AsciiCharacter.toAsciiByteValue(this.maskingConfig.getMaskNumberValuesWith()));
                            i -= targetValueLength - 1;
                            continue block0;
                        }
                        outputBytes = FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthMask(outputBytes, i, obfuscationLength, targetValueLength, AsciiCharacter.toAsciiByteValue(this.maskingConfig.getMaskNumberValuesWith()));
                        i -= targetValueLength - obfuscationLength;
                        continue block0;
                    }
                    if (!AsciiCharacter.isDoubleQuote(inputSliceBytes[i])) continue block0;
                    ++i;
                    targetValueLength = 0;
                    int noOfEscapeCharacters = 0;
                    int additionalBytesForEncoding = 0;
                    boolean escapeNextCharacter = false;
                    boolean previousCharacterCountedAsEscapeCharacter = false;
                    while (!AsciiCharacter.isDoubleQuote(inputSliceBytes[i]) || AsciiCharacter.isDoubleQuote(inputSliceBytes[i]) && escapeNextCharacter) {
                        if (Utf8Util.getCodePointByteLength(inputSliceBytes[i]) > 1) {
                            additionalBytesForEncoding += Utf8Util.getCodePointByteLength(inputSliceBytes[i]) - 1;
                        }
                        if ((escapeNextCharacter = AsciiCharacter.isEscapeCharacter(inputSliceBytes[i])) && !previousCharacterCountedAsEscapeCharacter) {
                            ++noOfEscapeCharacters;
                            previousCharacterCountedAsEscapeCharacter = true;
                        } else {
                            if (previousCharacterCountedAsEscapeCharacter && AsciiCharacter.isLowercaseU(inputSliceBytes[i])) {
                                additionalBytesForEncoding += 4;
                            }
                            previousCharacterCountedAsEscapeCharacter = false;
                        }
                        outputBytes[i + j] = AsciiCharacter.ASTERISK.getAsciiByteValue();
                        ++targetValueLength;
                        ++i;
                    }
                    int obfuscationLength = this.maskingConfig.getObfuscationLength();
                    if (this.maskingConfig.isObfuscationEnabled() && obfuscationLength != targetValueLength - obfuscationLength) {
                        outputBytes = FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthAsteriskMask(outputBytes, i + j, obfuscationLength, targetValueLength);
                        i -= targetValueLength - obfuscationLength;
                        continue block0;
                    }
                    if (noOfEscapeCharacters <= 0 && additionalBytesForEncoding <= 0) continue block0;
                    int actualStringLength = targetValueLength - noOfEscapeCharacters - additionalBytesForEncoding;
                    outputBytes = FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthAsteriskMask(outputBytes, i + j, actualStringLength, targetValueLength);
                    i = i - noOfEscapeCharacters - additionalBytesForEncoding;
                    continue block0;
                }
                ++i;
            }
        }
        return outputBytes;
    }
}

