/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.AsciiCharacter;
import dev.blaauwendraad.masker.Utf8Util;
import dev.blaauwendraad.masker.json.AsciiJsonUtil;
import dev.blaauwendraad.masker.json.FixedLengthTargetValueMaskUtil;
import dev.blaauwendraad.masker.json.JsonMasker;
import dev.blaauwendraad.masker.json.config.JsonMaskingConfig;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public final class KeyContainsMasker
implements JsonMasker {
    private static final int MIN_OFFSET_JSON_KEY_QUOTE = 4;
    private static final int MIN_MASKABLE_JSON_LENGTH = 7;
    private final Set<String> targetKeys;
    private final boolean allowMode;
    private final JsonMaskingConfig maskingConfig;

    public KeyContainsMasker(JsonMaskingConfig maskingConfig) {
        this.targetKeys = maskingConfig.getTargetKeys();
        this.allowMode = maskingConfig.getTargetKeyMode() == JsonMaskingConfig.TargetKeyMode.ALLOW;
        this.maskingConfig = maskingConfig;
    }

    @Override
    public byte[] mask(byte[] input) {
        if (!this.isObjectOrArray(input) || input.length < 7) {
            return input;
        }
        int i = 1;
        block0: while (i < input.length - 4) {
            int targetValueLength;
            while (!this.isUnescapedDoubleQuote(i, input)) {
                if (i >= input.length - 4 - 1) break block0;
                ++i;
            }
            int openingQuoteIndex = i++;
            while (!this.isUnescapedDoubleQuote(i, input) && i < input.length - 1) {
                if (i >= input.length - 4) break block0;
                ++i;
            }
            int closingQuoteIndex = i++;
            while (!AsciiCharacter.isColon(input[i])) {
                if (!AsciiJsonUtil.isWhiteSpace(input[i])) continue block0;
                ++i;
            }
            ++i;
            while (AsciiJsonUtil.isWhiteSpace(input[i])) {
                ++i;
            }
            if (!AsciiCharacter.isDoubleQuote(input[i]) && (this.maskingConfig.isNumberMaskingDisabled() || !AsciiJsonUtil.isFirstNumberChar(input[i]))) continue;
            int keyLength = closingQuoteIndex - openingQuoteIndex - 1;
            byte[] keyBytesBuffer = new byte[keyLength];
            System.arraycopy(input, openingQuoteIndex + 1, keyBytesBuffer, 0, keyLength);
            String key = new String(keyBytesBuffer, StandardCharsets.UTF_8);
            if (!this.maskingConfig.caseSensitiveTargetKeys()) {
                key = key.toLowerCase();
            }
            boolean keyMatched = this.targetKeys.contains(key);
            if (this.allowMode && keyMatched || !this.allowMode && !keyMatched) continue;
            int obfuscationLength = this.maskingConfig.getObfuscationLength();
            if (this.maskingConfig.isNumberMaskingEnabled() && AsciiJsonUtil.isNumericCharacter(input[i])) {
                targetValueLength = 0;
                while (AsciiJsonUtil.isNumericCharacter(input[i])) {
                    ++targetValueLength;
                    input[i] = AsciiCharacter.toAsciiByteValue(this.maskingConfig.getMaskNumberValuesWith());
                    ++i;
                }
                if (!this.maskingConfig.isObfuscationEnabled() || obfuscationLength == targetValueLength) continue;
                if (obfuscationLength == 0) {
                    input = FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthMask(input, i, 1, targetValueLength, AsciiCharacter.toAsciiByteValue(this.maskingConfig.getMaskNumberValuesWith()));
                    i -= targetValueLength - 1;
                    continue;
                }
                input = FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthMask(input, i, obfuscationLength, targetValueLength, AsciiCharacter.toAsciiByteValue(this.maskingConfig.getMaskNumberValuesWith()));
                i -= targetValueLength - obfuscationLength;
                continue;
            }
            ++i;
            targetValueLength = 0;
            int noOfEscapeCharacters = 0;
            int additionalBytesForEncoding = 0;
            boolean escapeNextCharacter = false;
            boolean previousCharacterCountedAsEscapeCharacter = false;
            while (!AsciiCharacter.isDoubleQuote(input[i]) || AsciiCharacter.isDoubleQuote(input[i]) && escapeNextCharacter) {
                if (Utf8Util.getCodePointByteLength(input[i]) > 1) {
                    additionalBytesForEncoding += Utf8Util.getCodePointByteLength(input[i]) - 1;
                }
                if ((escapeNextCharacter = AsciiCharacter.isEscapeCharacter(input[i])) && !previousCharacterCountedAsEscapeCharacter) {
                    ++noOfEscapeCharacters;
                    previousCharacterCountedAsEscapeCharacter = true;
                } else {
                    if (previousCharacterCountedAsEscapeCharacter && AsciiCharacter.isLowercaseU(input[i])) {
                        additionalBytesForEncoding += 4;
                    }
                    previousCharacterCountedAsEscapeCharacter = false;
                }
                input[i] = AsciiCharacter.ASTERISK.getAsciiByteValue();
                ++targetValueLength;
                ++i;
            }
            if (this.maskingConfig.isObfuscationEnabled() && obfuscationLength != targetValueLength - noOfEscapeCharacters) {
                input = FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthAsteriskMask(input, i, obfuscationLength, targetValueLength);
                i -= targetValueLength - obfuscationLength;
            } else if (noOfEscapeCharacters > 0 || additionalBytesForEncoding > 0) {
                int actualStringLength = targetValueLength - noOfEscapeCharacters - additionalBytesForEncoding;
                input = FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthAsteriskMask(input, i, actualStringLength, targetValueLength);
                i = i - noOfEscapeCharacters - additionalBytesForEncoding;
            }
            ++i;
        }
        return input;
    }

    private boolean isUnescapedDoubleQuote(int i, byte[] input) {
        return AsciiCharacter.isDoubleQuote(input[i]) && !AsciiCharacter.isEscapeCharacter(input[i - 1]);
    }

    private boolean isObjectOrArray(byte[] input) {
        return AsciiCharacter.CURLY_BRACKET_OPEN.getAsciiByteValue() == input[0] || AsciiCharacter.SQUARE_BRACKET_OPEN.getAsciiByteValue() == input[0];
    }
}

