/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.json.KeyContainsMasker;
import dev.blaauwendraad.masker.json.PathAwareKeyContainsMasker;
import dev.blaauwendraad.masker.json.SingleTargetMasker;
import dev.blaauwendraad.masker.json.config.JsonMaskerAlgorithmType;
import dev.blaauwendraad.masker.json.config.JsonMaskingConfig;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.annotation.Nonnull;

public interface JsonMasker {
    @Nonnull
    public static JsonMasker getMasker(String targetKey) {
        return JsonMasker.getMasker(JsonMaskingConfig.getDefault(Set.of(targetKey)));
    }

    @Nonnull
    public static JsonMasker getMasker(Set<String> targetKeys) {
        return JsonMasker.getMasker(JsonMaskingConfig.getDefault(targetKeys));
    }

    @Nonnull
    public static JsonMasker getMasker(JsonMaskingConfig maskingConfig) {
        if (maskingConfig.getAlgorithmType() == JsonMaskerAlgorithmType.SINGLE_TARGET_LOOP) {
            return new SingleTargetMasker(maskingConfig);
        }
        if (maskingConfig.getAlgorithmType() == JsonMaskerAlgorithmType.KEYS_CONTAIN) {
            return new KeyContainsMasker(maskingConfig);
        }
        return new PathAwareKeyContainsMasker(maskingConfig);
    }

    public byte[] mask(byte[] var1);

    @Nonnull
    default public String mask(String input) {
        return new String(this.mask(input.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }
}

