/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker.json;

import dev.blaauwendraad.masker.AsciiCharacter;

public final class FixedLengthTargetValueMaskUtil {
    private FixedLengthTargetValueMaskUtil() {
    }

    static byte[] replaceTargetValueWithFixedLengthMask(byte[] inputBytes, int targetValueEndIndex, int fixedMaskLength, int targetValueLength, byte maskByte) {
        byte[] newInputBytes = new byte[inputBytes.length + (fixedMaskLength - targetValueLength)];
        int targetValueStartIndex = targetValueEndIndex - targetValueLength;
        System.arraycopy(inputBytes, 0, newInputBytes, 0, targetValueStartIndex);
        for (int i = targetValueStartIndex; i < targetValueStartIndex + fixedMaskLength; ++i) {
            newInputBytes[i] = maskByte;
        }
        System.arraycopy(inputBytes, targetValueEndIndex, newInputBytes, targetValueStartIndex + fixedMaskLength, inputBytes.length - targetValueEndIndex);
        return newInputBytes;
    }

    static byte[] replaceTargetValueWithFixedLengthAsteriskMask(byte[] inputBytes, int closingQuoteIndex, int fixedLength, int targetValueLength) {
        return FixedLengthTargetValueMaskUtil.replaceTargetValueWithFixedLengthMask(inputBytes, closingQuoteIndex, fixedLength, targetValueLength, AsciiCharacter.ASTERISK.getAsciiByteValue());
    }
}

