/*
 * Decompiled with CFR 0.152.
 */
package dev.blaauwendraad.masker;

public enum AsciiCharacter {
    ASTERISK(42),
    BACK_SLASH(92),
    CARRIAGE_RETURN(13),
    COLON(58),
    COMMA(44),
    CURLY_BRACKET_OPEN(123),
    DOUBLE_QUOTE(34),
    HORIZONTAL_TAB(9),
    LINE_FEED(10),
    LOWERCASE_E(101),
    MINUS(45),
    PERIOD(46),
    PLUS(43),
    SPACE(32),
    SQUARE_BRACKET_OPEN(91),
    UPPERCASE_E(69),
    LOWERCASE_F(102),
    LOWERCASE_N(110),
    LOWERCASE_T(116),
    LOWERCASE_U(117),
    ZERO(48),
    ONE(49),
    TWO(50),
    THREE(51),
    FOUR(52),
    FIVE(53),
    SIX(54),
    SEVEN(55),
    EIGHT(56),
    NINE(57);

    final byte byteValue;

    private AsciiCharacter(byte byteValue) {
        this.byteValue = byteValue;
    }

    public static byte toAsciiByteValue(int digit) {
        return switch (digit) {
            case 0 -> AsciiCharacter.ZERO.byteValue;
            case 1 -> AsciiCharacter.ONE.byteValue;
            case 2 -> AsciiCharacter.TWO.byteValue;
            case 3 -> AsciiCharacter.THREE.byteValue;
            case 4 -> AsciiCharacter.FOUR.byteValue;
            case 5 -> AsciiCharacter.FIVE.byteValue;
            case 6 -> AsciiCharacter.SIX.byteValue;
            case 7 -> AsciiCharacter.SEVEN.byteValue;
            case 8 -> AsciiCharacter.EIGHT.byteValue;
            case 9 -> AsciiCharacter.NINE.byteValue;
            default -> throw new IllegalStateException("Unexpected digit: " + digit);
        };
    }

    public static boolean isDoubleQuote(byte inputByte) {
        return DOUBLE_QUOTE.getAsciiByteValue() == inputByte;
    }

    public static boolean isEscapeCharacter(byte inputByte) {
        return BACK_SLASH.getAsciiByteValue() == inputByte;
    }

    public static boolean isLowercaseU(byte inputByte) {
        return LOWERCASE_U.getAsciiByteValue() == inputByte;
    }

    public static boolean isColon(byte inputByte) {
        return COLON.getAsciiByteValue() == inputByte;
    }

    public byte getAsciiByteValue() {
        return this.byteValue;
    }
}

