/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.zmon.eventlogservice;

import de.zalando.zmon.eventlogservice.CassandraStore;
import de.zalando.zmon.eventlogservice.EventStore;
import de.zalando.zmon.eventlogservice.PostgresqlStore;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableAutoConfiguration
@Configuration
public class StoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFactory.class);
    @Value(value="${cassandra.host:}")
    String cassandraHost;
    @Value(value="${cassandra.port:0}")
    int cassandraPort;
    @Value(value="${cassandra.keyspace:null}")
    String cassandraKeyspace;
    @Value(value="${postgresql.host:localhost}")
    String postgresqlHost;
    @Value(value="${postgresql.port:5432}")
    int postgresqlPort;
    @Value(value="${postgresql.database:local_zmon_db}")
    String postgresqlDatabase;
    @Value(value="${postgresql.user:postgres}")
    String postgresqlUser;
    @Value(value="${postgresql.password}")
    String postgresqlPassword;
    @Value(value="${postgresql.schema:zmon_eventlog}")
    String postgresqlSchema;
    @Autowired
    private DataSource dataSource;

    @Bean
    public EventStore getStore() {
        if (this.cassandraHost.equals("")) {
            LOG.info("Initialize Postgresql-EventStore ...");
            return new PostgresqlStore(this.dataSource, this.postgresqlSchema);
        }
        LOG.info("Initialize Cassandra-EventStore ...");
        return new CassandraStore(this.cassandraHost, this.cassandraPort, this.cassandraKeyspace);
    }
}

