/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.zmon.eventlogservice;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.zalando.zmon.eventlogservice.Event;
import de.zalando.zmon.eventlogservice.EventStore;
import de.zalando.zmon.eventlogservice.JsonSupport;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.postgresql.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.scheduling.annotation.Async;

public class PostgresqlStore
implements EventStore,
JsonSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresqlStore.class);
    private final DataSource dataSource;
    private final JdbcTemplate jdbc;
    private final String queryGet;
    private final String queryInsert;
    private final RowMapper<Event> eventRowMapper = new EventRowMapper();

    public PostgresqlStore(DataSource dataSource, String schema) {
        this.dataSource = dataSource;
        this.jdbc = new JdbcTemplate(this.dataSource);
        this.queryInsert = "INSERT INTO " + schema + ".events(e_type_id, e_created, e_instance_id, e_data) VALUES(?,?,?,?::jsonb)";
        this.queryGet = "SELECT e_type_id, e_created, e_instance_id, e_data, et_name FROM " + schema + ".events, " + schema + ".event_types WHERE et_id = e_type_id AND e_data @> '";
    }

    @Override
    @Async
    public void putEvent(Event event, String key) {
        this.writeAsString(event.getAttributes()).ifPresent(attr -> this.writeEvent(event, (String)attr));
    }

    protected void writeEvent(Event event, String attributes) {
        LOG.debug("SQL : {}, PARAMS : {}", (Object)this.queryInsert, (Object)new String[]{event.getTypeId() + "", new Timestamp(event.getTime().getTime()).toString(), attributes});
        this.jdbc.update(this.queryInsert, new Object[]{event.getTypeId(), new Timestamp(event.getTime().getTime()), 0, attributes});
    }

    @Override
    public boolean isBatchSupported() {
        return true;
    }

    @Override
    @Async
    public void storeInBatch(final Iterable<Event> toStore) {
        int[] result = this.jdbc.batchUpdate(this.queryInsert, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Event event = (Event)Iterables.get((Iterable)toStore, (int)i);
                ps.setInt(1, event.getTypeId());
                ps.setTimestamp(2, new Timestamp(event.getTime().getTime()));
                ps.setInt(3, 0);
                ps.setString(4, PostgresqlStore.this.writeAsString(event.getAttributes()).orElse("{}"));
            }

            public int getBatchSize() {
                return Iterables.size((Iterable)toStore);
            }
        });
        LOG.info("SAVED IN BATCH : {}", (Object)result);
    }

    @Override
    public List<Event> getEvents(String key, String value, List<Integer> types, int limit) {
        ArrayList events = Lists.newArrayList();
        this.buildQueryString(key, value, types).ifPresent(sql -> this.executeQuery((String)sql, limit, events));
        return events;
    }

    protected void executeQuery(String query, int limit, List<Event> events) {
        events.addAll(this.jdbc.query(query, new Object[0], this.eventRowMapper));
    }

    protected Optional<String> buildQueryString(String key, String value, List<Integer> types) {
        StringBuffer b = new StringBuffer();
        b.append(this.queryGet);
        try {
            Utils.appendEscapedLiteral((StringBuffer)b, (String)("{\"" + key + "\":\"" + value + "\"}"), (boolean)true);
        }
        catch (SQLException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        b.append("'");
        if (null != types && types.size() > 0) {
            b.append(" AND e_type_id IN (");
            boolean first = true;
            for (Integer t : types) {
                if (!first) {
                    b.append(",");
                }
                first = false;
                b.append(t.toString());
            }
            b.append(")");
        }
        LOG.debug("QUERY : {}", (Object)b.toString());
        return Optional.ofNullable(b.toString());
    }

    static class EventRowMapper
    implements RowMapper<Event>,
    JsonSupport {
        private static final TypeReference<Map<String, String>> typeRef = new TypeReference<Map<String, String>>(){};

        EventRowMapper() {
        }

        public Event mapRow(ResultSet rs, int rowNum) throws SQLException {
            Event e = new Event();
            e.setTime(new Date(rs.getTimestamp(2).getTime()));
            e.setTypeId(rs.getInt(1));
            e.setTypeName(rs.getString(5));
            Map data = this.readValue(rs.getString(4), typeRef).orElse(Maps.newHashMap());
            e.setAttributes(data);
            return e;
        }
    }
}

