/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.zmon.eventlogservice;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;

public interface JsonSupport {
    public static final ObjectMapper objectMapper = new ObjectMapper();

    default public Optional<String> writeAsString(Object object) {
        if (object == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(this.getObjectMapper().writeValueAsString(object));
        }
        catch (JsonProcessingException e) {
            this.getLogger().ifPresent(logger -> logger.warn("Failed to serialize map", (Throwable)e));
            return Optional.empty();
        }
    }

    default public <T> Optional<T> readValue(String value, TypeReference<T> typeRef) {
        try {
            return Optional.ofNullable(this.getObjectMapper().readValue(value, typeRef));
        }
        catch (JsonParseException e) {
            this.getLogger().ifPresent(logger -> logger.warn(e.getMessage(), (Throwable)e));
        }
        catch (JsonMappingException e) {
            this.getLogger().ifPresent(logger -> logger.warn(e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            this.getLogger().ifPresent(logger -> logger.warn(e.getMessage(), (Throwable)e));
        }
        return Optional.empty();
    }

    default public ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    default public Optional<Logger> getLogger() {
        return Optional.empty();
    }
}

