/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.zmon.eventlogservice;

import de.zalando.zmon.eventlogservice.Event;
import de.zalando.zmon.eventlogservice.EventStore;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
class EventlogController {
    private final EventStore storage;
    private static final Predicate<Event> EVENT_FILTER = new EventFilterByAttribute("alertId").or(new EventFilterByAttribute("checkId"));

    @Autowired
    EventlogController(EventStore eventStore) {
        Assert.notNull((Object)eventStore, (String)"'EventStore' should never be null");
        this.storage = eventStore;
    }

    @RequestMapping(value={"/"})
    List<Event> getEvents(@RequestParam(value="types") List<Integer> types, @RequestParam(value="key") String key, @RequestParam(value="value") String value) {
        return this.storage.getEvents(key, value, types, 100);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.PUT}, consumes={"application/json"})
    void putEvents(@RequestBody List<Event> events) {
        if (this.storage.isBatchSupported()) {
            List filtered = events.stream().filter(EVENT_FILTER).collect(Collectors.toList());
            this.storage.storeInBatch(filtered);
        } else {
            for (Event e : events) {
                if (e.getAttributes().containsKey("alertId")) {
                    this.storage.putEvent(e, "alertId");
                    continue;
                }
                if (!e.getAttributes().containsKey("checkId")) continue;
                this.storage.putEvent(e, "checkId");
            }
        }
    }

    static class EventFilterByAttribute
    implements Predicate<Event> {
        private final String attributesKey;

        public EventFilterByAttribute(String attributeKey) {
            Assert.hasText((String)attributeKey, (String)"'attributeKey' should never be null or empty");
            this.attributesKey = attributeKey;
        }

        @Override
        public boolean test(Event t) {
            return t.getAttributes().containsKey(this.attributesKey);
        }
    }
}

