/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.zmon.eventlogservice;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import de.zalando.zmon.eventlogservice.Event;
import de.zalando.zmon.eventlogservice.EventStore;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStore
implements EventStore {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraStore.class);
    private final String host;
    private final int port;
    private final String keyspace;
    private final Cluster cluster;
    private final Session session;
    private PreparedStatement getByAlertId;
    private PreparedStatement getByCheckId;
    private PreparedStatement putByAlertId;
    private PreparedStatement putByCheckId;

    private void setupCassandra() {
        ResultSet rs = this.session.execute("SELECT * FROM system.schema_keyspaces WHERE keyspace_name = 'eventlog'");
        List rows = rs.all();
        if (rows.size() == 0) {
            LOG.info("Creating eventlog keyspace");
            this.session.execute("CREATE KEYSPACE eventlog WITH replication = {'class':'SimpleStrategy', 'replication_factor': 2};");
        }
        SimpleStatement st = new SimpleStatement("select * from system.schema_columnfamilies where keyspace_name = 'eventlog' and columnfamily_name = 'events_by_alert_id';");
        st.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        rs = this.session.execute((Statement)st);
        rows = rs.all();
        if (rows.size() == 0) {
            LOG.info("Creating table for events by alert id");
            this.session.execute("CREATE TABLE eventlog.events_by_alert_id(alert_id int, created timestamp, type int, entity text, instance_id int, data map<text,text>, PRIMARY KEY(alert_id, created)) WITH CLUSTERING ORDER BY (created DESC);");
        }
        st = new SimpleStatement("select * from system.schema_columnfamilies where keyspace_name = 'eventlog' and columnfamily_name = 'events_by_check_id';");
        st.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        rs = this.session.execute((Statement)st);
        rows = rs.all();
        if (rows.size() == 0) {
            LOG.info("Creating table for events by check id");
            this.session.execute("CREATE TABLE eventlog.events_by_check_id(check_id int, created timestamp, type int, entity text, instance_id int, data map<text,text>, PRIMARY KEY(check_id, created)) WITH CLUSTERING ORDER BY (created DESC);");
        }
    }

    private void prepareStatements() {
        this.putByAlertId = this.session.prepare("INSERT INTO eventlog.events_by_alert_id(alert_id,created,type,entity,instance_id,data) VALUES(?,?,?,?,?,?)");
        this.putByCheckId = this.session.prepare("INSERT INTO eventlog.events_by_check_id(check_id,created,type,entity,instance_id,data) VALUES(?,?,?,?,?,?)");
        this.getByAlertId = this.session.prepare("SELECT * FROM eventlog.events_by_alert_id WHERE alert_id = ? LIMIT ?");
        this.getByCheckId = this.session.prepare("SELECT * FROM eventlog.events_by_check_id WHERE check_id = ? LIMIT ?");
    }

    public CassandraStore(String host, int port, String keyspace) {
        this.host = host;
        this.port = port;
        this.keyspace = keyspace;
        LOG.info("Cassandra settings: {} {} {}", new Object[]{host, port, keyspace});
        this.cluster = Cluster.builder().addContactPoint(host).build();
        this.session = this.cluster.newSession();
        this.setupCassandra();
        this.prepareStatements();
    }

    @Override
    public void putEvent(Event event, String key) {
        BoundStatement bst = null;
        if ("alertId".equals(key)) {
            bst = this.putByAlertId.bind(new Object[]{Integer.parseInt(event.getAttributes().get("alertId")), event.getTime(), event.getTypeId(), event.getAttributes().get("entity"), 0, event.getAttributes()});
        } else if ("checkId".equals(key)) {
            bst = this.putByCheckId.bind(new Object[]{Integer.parseInt(event.getAttributes().get("checkId")), event.getTime(), event.getTypeId(), event.getAttributes().get("entity"), 0, event.getAttributes()});
        }
        if (bst != null) {
            this.session.execute(bst);
        }
    }

    @Override
    public List<Event> getEvents(String key, String value, List<Integer> types, int limit) {
        ArrayList<Event> l = new ArrayList<Event>(limit);
        BoundStatement bst = null;
        if ("alertId".equals(key)) {
            bst = this.getByAlertId.bind(new Object[]{Integer.parseInt(value), limit});
        } else if ("checkId".equals(key)) {
            bst = this.getByAlertId.bind(new Object[]{Integer.parseInt(value), limit});
        }
        if (bst == null) {
            return l;
        }
        ResultSet rs = this.session.execute(bst);
        for (Row r : rs) {
            if (!types.contains(r.getInt("type"))) continue;
            Event e = new Event();
            e.setTypeId(r.getInt("type"));
            e.setTime(r.getDate("created"));
            e.setAttributes(r.getMap("data", String.class, String.class));
            l.add(e);
        }
        return l;
    }
}

