/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.spring.cloud.config.aws.kms;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClient;
import de.zalando.spring.cloud.config.aws.kms.KmsTextEncryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.bootstrap.encrypt.EnvironmentDecryptApplicationInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.TextEncryptor;

@Configuration
@ConditionalOnProperty(prefix="aws.kms", name={"enabled"}, havingValue="true", matchIfMissing=true)
class KmsEncryptionConfiguration {
    @Autowired
    private KmsTextEncryptor kmsTextEncryptor;

    KmsEncryptionConfiguration() {
    }

    @Bean
    EnvironmentDecryptApplicationInitializer environmentDecryptApplicationInitializer() {
        return new EnvironmentDecryptApplicationInitializer((TextEncryptor)this.kmsTextEncryptor);
    }

    @Configuration
    @ConditionalOnMissingBean(value={AWSKMS.class})
    static class KmsConfiguration {
        @Value(value="#{T(com.amazonaws.regions.Regions).fromName('${aws.region}')}")
        private Regions region;

        KmsConfiguration() {
        }

        @Bean
        AWSKMS kms() {
            AWSKMSClient awskmsClient = new AWSKMSClient();
            awskmsClient.setRegion(this.region);
            return awskmsClient;
        }
    }

    @Configuration
    static class KmsTextEncryptorConfiguration {
        @Value(value="${aws.kms.keyId:}")
        private String kmsKeyId;
        @Autowired
        private AWSKMS kms;

        KmsTextEncryptorConfiguration() {
        }

        @Bean
        KmsTextEncryptor kmsTextEncryptor() {
            return new KmsTextEncryptor(this.kms, this.kmsKeyId);
        }
    }
}

