/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.spring.cloud.config.aws.kms;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.kms.AWSKMSClient;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.EncryptRequest;
import java.nio.ByteBuffer;
import java.util.Base64;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.Assert;

public class KmsTextEncryptor
implements TextEncryptor {
    private static final String EMPTY_STRING = "";
    private final String kmsKeyId;
    private final Regions region;
    private AWSKMSClient kms;

    public KmsTextEncryptor(String kmsKeyId, Regions region) {
        Assert.notNull((Object)region, (String)"region must not be null");
        Assert.hasText((String)kmsKeyId, (String)"kmsKeyId must not be blank");
        this.kmsKeyId = kmsKeyId;
        this.region = region;
    }

    protected AWSKMSClient getKms() {
        if (this.kms == null) {
            this.kms = new AWSKMSClient();
            this.kms.setRegion(this.region);
        }
        return this.kms;
    }

    public String encrypt(String text) {
        EncryptRequest encryptRequest = new EncryptRequest().withKeyId(this.kmsKeyId).withPlaintext(ByteBuffer.wrap(text.getBytes()));
        ByteBuffer encryptedBytes = this.getKms().encrypt(encryptRequest).getCiphertextBlob();
        return KmsTextEncryptor.extractString(Base64.getEncoder().encode(encryptedBytes));
    }

    public String decrypt(String encryptedText) {
        ByteBuffer encryptedBytes = Base64.getDecoder().decode(ByteBuffer.wrap(encryptedText.getBytes()));
        DecryptRequest decryptRequest = new DecryptRequest().withCiphertextBlob(encryptedBytes);
        return KmsTextEncryptor.extractString(this.getKms().decrypt(decryptRequest).getPlaintext());
    }

    private static String extractString(ByteBuffer bb) {
        if (bb.hasRemaining()) {
            byte[] bytes = new byte[bb.remaining()];
            bb.get(bytes, bb.arrayOffset(), bb.remaining());
            return new String(bytes);
        }
        return EMPTY_STRING;
    }
}

