/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.spring.cloud.config.aws.kms;

import com.amazonaws.regions.Regions;
import de.zalando.spring.cloud.config.aws.kms.KmsTextEncryptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.bootstrap.encrypt.EnvironmentDecryptApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.TextEncryptor;

@Configuration
class KmsEncryptionConfiguration {
    @Value(value="${aws.kms.keyId}")
    private String kmsKeyId;
    @Value(value="${aws.region}")
    private String regionName;

    KmsEncryptionConfiguration() {
    }

    @Bean
    TextEncryptor kmsTextEncryptor() {
        return new KmsTextEncryptor(this.kmsKeyId, Regions.fromName((String)this.regionName));
    }

    @Bean
    EnvironmentDecryptApplicationListener environmentDecryptApplicationListener() {
        return new EnvironmentDecryptApplicationListener(this.kmsTextEncryptor());
    }
}

