/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.eventlog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import de.zalando.eventlog.EventType;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class EventLogger {
    private static final Logger EVENT_LOG = Logger.getLogger((String)"eventlog");
    private static final Logger EVENT_LOG_LAYOUT = Logger.getLogger((String)"eventlog-layout");
    private static final Logger LOG = Logger.getLogger(EventLogger.class);
    private static final Pattern VALID_FIELD_NAME_PATTERN = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
    private static EventLogger instance;
    private final Map<Integer, Boolean> eventTypes = Maps.newConcurrentMap();

    public static EventLogger getLogger(Class clazz) {
        if (instance == null) {
            DailyRollingFileAppender appender;
            EVENT_LOG.setLevel(Level.INFO);
            EVENT_LOG.setAdditivity(false);
            PatternLayout layout = new PatternLayout("%d %x %m%n");
            String filename = System.getProperty("eventlog.filename");
            if (filename == null) {
                filename = "eventlog.log";
                String jvmProcessName = System.getProperty("jvm.process.name");
                if (jvmProcessName != null) {
                    filename = "/data/zalando/logs/" + jvmProcessName + "/" + filename;
                }
            }
            try {
                appender = new DailyRollingFileAppender((Layout)layout, filename, "'.'yyyy-MM-dd");
                EVENT_LOG.addAppender((Appender)appender);
            }
            catch (IOException ioe) {
                LOG.error((Object)("Could not initialize eventlog appender for class " + clazz.getName()), (Throwable)ioe);
            }
            EVENT_LOG_LAYOUT.setLevel(Level.INFO);
            EVENT_LOG_LAYOUT.setAdditivity(false);
            layout = new PatternLayout("%d %m%n");
            try {
                appender = new DailyRollingFileAppender((Layout)layout, filename.replace(".log", ".layout"), "'.'yyyy-MM-dd");
                EVENT_LOG_LAYOUT.addAppender((Appender)appender);
            }
            catch (IOException ioe) {
                LOG.error((Object)("Could not initialize eventlog layout appender for class " + clazz.getName()), (Throwable)ioe);
            }
            instance = new EventLogger();
        }
        return instance;
    }

    private String getValue(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\t", "\\t").replace("\n", "\\n");
    }

    private void logLayout(EventType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(type.getId()));
        sb.append('\t');
        sb.append(this.getValue(type.getName()));
        for (String name : type.getFieldNames()) {
            Preconditions.checkArgument((boolean)VALID_FIELD_NAME_PATTERN.matcher(name).matches(), (String)"invalid event field name: '%s'", (Object[])new Object[]{name});
            sb.append('\t');
            sb.append(this.getValue(name));
        }
        EVENT_LOG_LAYOUT.info((Object)sb.toString());
    }

    public void log(EventType type, Object ... values) {
        Preconditions.checkArgument((values.length <= type.getFieldNames().size() ? 1 : 0) != 0, (String)"too many event values for %s (number of values: %s, number of fields: %s)", (Object[])new Object[]{type.getName(), values.length, type.getFieldNames().size()});
        int id = type.getId();
        if (!this.eventTypes.containsKey(id)) {
            this.logLayout(type);
            this.eventTypes.put(id, true);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(id));
        int i = 0;
        for (Object o : values) {
            sb.append('\t');
            sb.append(this.getValue(o));
            ++i;
        }
        EVENT_LOG.info((Object)sb.toString());
    }
}

