/*
 * Decompiled with CFR 0.152.
 */
package de.yourinspiration.jexpresso.basicauth;

import io.netty.handler.codec.http.HttpMethod;
import java.util.Arrays;

public class SecurityRoute {
    private final String path;
    private final String authorities;
    private final HttpMethod[] methods;
    private final String pathPattern;

    protected SecurityRoute(String path, String authorities, HttpMethod[] methods) {
        this.path = path;
        this.authorities = authorities;
        this.methods = methods.length == 0 ? new HttpMethod[]{HttpMethod.GET, HttpMethod.CONNECT, HttpMethod.DELETE, HttpMethod.HEAD, HttpMethod.OPTIONS, HttpMethod.POST, HttpMethod.PUT, HttpMethod.TRACE} : methods;
        Arrays.sort(this.methods);
        String adjustedPath = this.path.replaceAll("\\*", ".*");
        this.pathPattern = "^" + adjustedPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getAuthorities() {
        return this.authorities;
    }

    public HttpMethod[] getMethods() {
        return this.methods;
    }

    public boolean matchesPathAndMethod(String pathToMatch, HttpMethod method) {
        return Arrays.binarySearch(this.methods, method) > -1 && pathToMatch.matches(this.pathPattern);
    }
}

