/*
 * Decompiled with CFR 0.152.
 */
package de.yourinspiration.jexpresso.basicauth;

import de.yourinspiration.jexpresso.MiddlewareHandler;
import de.yourinspiration.jexpresso.Next;
import de.yourinspiration.jexpresso.Request;
import de.yourinspiration.jexpresso.Response;
import de.yourinspiration.jexpresso.baseauth.GrantedAuthority;
import de.yourinspiration.jexpresso.baseauth.PasswordEncoder;
import de.yourinspiration.jexpresso.baseauth.UserDetails;
import de.yourinspiration.jexpresso.baseauth.UserDetailsService;
import de.yourinspiration.jexpresso.baseauth.UserNotFoundException;
import de.yourinspiration.jexpresso.basicauth.SecurityRoute;
import de.yourinspiration.jexpresso.http.HttpStatus;
import io.netty.handler.codec.http.HttpMethod;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.pmw.tinylog.Logger;

public class BasicAuthentation
implements MiddlewareHandler {
    public static final String USER_DETAILS_ATTR = "userDetails";
    private final UserDetailsService userDetailsService;
    private final PasswordEncoder passwordEncoder;
    private final List<SecurityRoute> securityRoutes = new ArrayList<SecurityRoute>();

    public BasicAuthentation(UserDetailsService userDetailsService, PasswordEncoder passwordEncoder) {
        this.userDetailsService = userDetailsService;
        this.passwordEncoder = passwordEncoder;
    }

    public void securePath(String path, String authorities, HttpMethod ... methods) {
        this.securityRoutes.add(new SecurityRoute(path, authorities, methods));
    }

    public void handle(Request request, Response response, Next next) {
        if (this.checkSecurityProviders(request, response)) {
            next.next();
        } else {
            next.cancel();
        }
    }

    private boolean checkSecurityProviders(Request request, Response response) {
        String path = this.getUri(request);
        HttpMethod method = request.method();
        for (SecurityRoute route : this.securityRoutes) {
            if (!route.matchesPathAndMethod(path, method)) continue;
            boolean authenticated = this.checkAuthentication(request, this.userDetailsService, this.passwordEncoder);
            if (!authenticated) {
                this.handleUnauthenticated(response);
                return false;
            }
            return true;
        }
        return true;
    }

    private String getUri(Request request) {
        if (request.path().contains("?")) {
            return request.path().substring(0, request.path().indexOf("?"));
        }
        return request.path();
    }

    private void handleUnauthenticated(Response response) {
        response.status(HttpStatus.UNAUTHORIZED);
        response.set("WWW-Authenticate", "Basic realm=\"sparkle realm\"");
        response.type("text/plain");
        response.send((Object)"");
    }

    private boolean checkAuthentication(Request request, UserDetailsService userDetailsService, PasswordEncoder passwordEncoder) {
        boolean authenticated = false;
        String authorization = request.get("Authorization");
        if (authorization != null && authorization.startsWith("Basic")) {
            String base64Credentials = authorization.substring("Basic".length()).trim();
            String credentials = new String(Base64.getDecoder().decode(base64Credentials), Charset.forName("UTF-8"));
            String[] values = credentials.split(":", 2);
            try {
                String authorities;
                UserDetails userDetails = userDetailsService.loadUserByUsername(values[0]);
                if (userDetails != null && passwordEncoder.checkpw(values[1], userDetails.getPassword()) && this.hasGrantedAuthoriy(userDetails, authorities = this.getAuthoritiesForRoute(request.path(), request.method()))) {
                    request.attribute(USER_DETAILS_ATTR, (Object)userDetails);
                    authenticated = true;
                }
            }
            catch (UserNotFoundException e) {
                Logger.debug((String)"User not found", (Object[])new Object[]{e});
            }
        }
        return authenticated;
    }

    private String getAuthoritiesForRoute(String path, HttpMethod method) {
        for (SecurityRoute securityRoute : this.securityRoutes) {
            if (!securityRoute.matchesPathAndMethod(path, method)) continue;
            return securityRoute.getAuthorities();
        }
        return "";
    }

    private boolean hasGrantedAuthoriy(UserDetails userDetails, String authorities) {
        if ("".equals(authorities.trim())) {
            return true;
        }
        for (GrantedAuthority grantedAuthority : userDetails.getAuthorities()) {
            for (String authority : authorities.split(",")) {
                if (!grantedAuthority.getAuthority().equalsIgnoreCase(authority)) continue;
                return true;
            }
        }
        return false;
    }
}

