/*
 * Decompiled with CFR 0.152.
 */
package de.yourinspiration.jexpresso.accesslog;

import de.yourinspiration.jexpresso.Request;
import de.yourinspiration.jexpresso.Response;
import de.yourinspiration.jexpresso.ResponseListener;
import de.yourinspiration.jexpresso.accesslog.AccessLogFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.text.DateFormat;
import java.util.Date;
import org.pmw.tinylog.Logger;

public class AccessLogResponseListener
implements ResponseListener {
    private static final DateFormat df = DateFormat.getDateTimeInstance(3, 2);
    private final AccessLogFormat format;
    private final WritableByteChannel channel;
    private final long start = System.currentTimeMillis();

    protected AccessLogResponseListener(AccessLogFormat format, WritableByteChannel channel) {
        this.format = format;
        this.channel = channel;
    }

    public void callback(Request request, Response response) {
        try {
            this.channel.write(ByteBuffer.wrap(this.getMessage(request, response).toString().getBytes()));
        }
        catch (IOException e) {
            Logger.error((Throwable)e, (String)"Error writing access log message: {0}", (Object[])new Object[]{e.getMessage()});
        }
    }

    private String getMessage(Request request, Response response) {
        String message = df.format(new Date()) + ": ";
        switch (this.format) {
            case DEVELOPER: {
                message = message + this.getDeveloperMessage(request, response);
                break;
            }
            case SMALL: {
                message = message + this.getSmallMessage(request, response);
                break;
            }
            case TINY: {
                message = message + this.getTinyMessage(request, response);
            }
        }
        return message;
    }

    private long getDuration() {
        return System.currentTimeMillis() - this.start;
    }

    private String getDeveloperMessage(Request request, Response response) {
        return request.method() + " " + request.path() + " " + request.ip() + " " + " " + response.status().value() + " " + response.status().getReasonPhrase() + " " + this.getDuration() + "ms\n";
    }

    private String getSmallMessage(Request request, Response response) {
        return request.method() + " " + request.path() + " " + request.ip() + " " + " " + response.status().value() + "\n";
    }

    private String getTinyMessage(Request request, Response response) {
        return request.method() + " " + request.path() + "\n";
    }
}

