package de.yourinspiration.configuration.impl;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import de.yourinspiration.configuration.Configuration;
import de.yourinspiration.configuration.ConfigurationValue;

/**
 * Read properties as values from the system environment.
 * 
 * @author Marcel Härle - marcel@yourinspiration.de
 *
 */
public class EnvironmentConfiguration implements Configuration {

    @Override
    public ConfigurationValue get(String name) {
	if (name == null) {
	    throw new IllegalArgumentException("the name must not be null");
	}
	return new ConfigurationValueImpl(getenv().get(name));
    }

    @Override
    public void set(String name, Object value) {
	if (name == null || value == null) {
	    throw new IllegalArgumentException("name and value must not be null");
	}
	getenv().put(name, value.toString());
    }

    @SuppressWarnings("unchecked")
    private Map<String, String> getenv() {
	try {
	    Map<String, String> unomdifiable = System.getenv();
	    Class<?> cu = unomdifiable.getClass();
	    Field m = cu.getDeclaredField("m");
	    m.setAccessible(true);
	    return (Map<String, String>) m.get(unomdifiable);
	} catch (Exception e) {
	}
	return new HashMap<String, String>();
    }

}
