package de.yourinspiration.configuration.impl;

import java.util.Optional;

import de.yourinspiration.configuration.ConfigurationValue;

public class ConfigurationValueImpl implements ConfigurationValue {

    private final String value;

    protected ConfigurationValueImpl(final String value) {
	this.value = value;
    }

    @Override
    public Optional<String> asString() {
	return Optional.ofNullable(value);
    }

    @Override
    public Optional<Integer> asInt() {
	try {
	    return Optional.ofNullable(Integer.parseInt(value));
	} catch (NumberFormatException e) {
	    return Optional.empty();
	}
    }

    @Override
    public Optional<Long> asLong() {
	try {
	    return Optional.ofNullable(Long.parseLong(value));
	} catch (NumberFormatException e) {
	    return Optional.empty();
	}
    }

    @Override
    public Optional<Boolean> asBoolean() {
	return Optional.ofNullable(Boolean.parseBoolean(value));
    }

    @Override
    public String asStringOrDefault(String defaultValue) {
	if (value == null) {
	    return defaultValue;
	} else {
	    return value;
	}
    }

    @Override
    public int asIntOrDefault(int defaultValue) {
	if (value == null) {
	    return defaultValue;
	}
	try {
	    return Integer.parseInt(value);
	} catch (NumberFormatException e) {
	    return defaultValue;
	}
    }

    @Override
    public long asLongOrDefault(long defaultValue) {
	if (value == null) {
	    return defaultValue;
	}
	try {
	    return Long.parseLong(value);
	} catch (NumberFormatException e) {
	    return defaultValue;
	}
    }

    @Override
    public boolean asBooleanOrDefault(boolean defaultValue) {
	if (value == null) {
	    return defaultValue;
	}
	if (value.equalsIgnoreCase("true")) {
	    return true;
	}
	if (value.equalsIgnoreCase("false")) {
	    return false;
	}
	return defaultValue;
    }

}
