package de.yourinspiration.configuration;

/**
 * A configuration can read and write properties as key value pairs to or from a
 * specific source.
 * 
 * @author Marcel Härle - marcel@yourinspiration.de
 *
 */
public interface Configuration {

    /**
     * Retrieves the property value for the given name.
     * 
     * @param name
     *            the of the property
     * @return returns the value of the property
     */
    ConfigurationValue get(String name);

    /**
     * Sets the value for the given name.
     * 
     * @param name
     *            the name of the property - must not be null
     * @param value
     *            the value of the property - must not be null
     */
    void set(String name, Object value);

}
