/*
 * Decompiled with CFR 0.152.
 */
package de.yourinspiration.configuration.impl;

import de.yourinspiration.configuration.ConfigurationValue;
import java.util.Optional;

public class ConfigurationValueImpl
implements ConfigurationValue {
    private final String value;

    protected ConfigurationValueImpl(String value) {
        this.value = value;
    }

    @Override
    public Optional<String> asString() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public Optional<Integer> asInt() {
        try {
            return Optional.ofNullable(Integer.parseInt(this.value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Long> asLong() {
        try {
            return Optional.ofNullable(Long.parseLong(this.value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Boolean> asBoolean() {
        return Optional.ofNullable(Boolean.parseBoolean(this.value));
    }
}

