package de.yourinspiration.configuration;

import java.util.Optional;

/**
 * Holds the value of a configuration property and provides type save access the
 * value.
 * 
 * @author Marcel Härle - marcel@yourinspiration.de
 *
 */
public interface ConfigurationValue {

    /**
     * Retrieves the property value as a string.
     * 
     * @return returns an empty optional of the value is not present
     */
    Optional<String> asString();

    /**
     * Retrieves the property value as an integer.
     * 
     * @return returns an empty optional of the value is not present or could
     *         not be parsed as an integer
     */
    Optional<Integer> asInt();

    /**
     * Retrieves the property value as a long.
     * 
     * @return returns an empty optional of the value is not present or could
     *         not be parsed as a long
     */
    Optional<Long> asLong();

    /**
     * Retrieves the property value as a boolean.
     * 
     * @return returns an empty optional of the value is not present or could
     *         not be parsed as a boolean
     */
    Optional<Boolean> asBoolean();

}
