/*
 * Decompiled with CFR 0.152.
 */
package de.yanwittmann.util;

import de.yanwittmann.j2chartjs.chart.MixedChart;
import de.yanwittmann.j2chartjs.data.ChartData;
import de.yanwittmann.j2chartjs.data.MixedChartData;
import de.yanwittmann.j2chartjs.options.AbstractChartOption;
import de.yanwittmann.j2chartjs.options.animation.AnimationEasingType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Util {
    private static final Set<String> STRING_ARRAY_IDENTIFIERS = new HashSet<String>(){
        {
            this.add("pointBackgroundColor");
            this.add("pointBorderColor");
            this.add("pointHoverBackgroundColor");
            this.add("pointHoverBorderColor");
            this.add("pointStyle");
            this.add("backgroundColor");
            this.add("borderColor");
            this.add("hoverBackgroundColor");
            this.add("hoverBorderColor");
            this.add("borderSkipped");
            this.add("hoverBorderSkipped");
        }
    };
    private static final Set<String> INTEGER_ARRAY_IDENTIFIERS = new HashSet<String>(){
        {
            this.add("pointBorderWidth");
            this.add("pointHitRadius");
            this.add("pointRadius");
            this.add("pointRotation");
            this.add("pointHoverBorderWidth");
            this.add("pointHoverRadius");
            this.add("borderWidth");
            this.add("borderRadius");
            this.add("hoverBorderWidth");
            this.add("hoverBorderRadius");
            this.add("rotation");
        }
    };
    private static final String INSERT_PATTERN = "(\"data\":\\[([^\\]]+)\\][^{}]+)?\"%s\":\\[([^\\]]+)\\]([^{}]+\"data\":\\[([^\\]]+)\\])?";

    public static JSONObject deepMerge(JSONObject source, JSONObject target) throws JSONException {
        if (source == null || target == null || source.length() == 0) {
            return target;
        }
        for (String key : JSONObject.getNames((JSONObject)source)) {
            Object value = source.get(key);
            if (!target.has(key)) {
                target.put(key, value);
                continue;
            }
            if (value instanceof JSONObject) {
                JSONObject valueJson = (JSONObject)value;
                Util.deepMerge(valueJson, target.getJSONObject(key));
                continue;
            }
            target.put(key, value);
        }
        return target;
    }

    public static List initializeListIfNull(List list) {
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public static void addToJson(JSONObject json, String key, Object element) {
        if (json == null || element == null || key == null) {
            return;
        }
        if (element instanceof List) {
            if (((List)element).size() > 0) {
                ArrayList<Object> convertedElements = new ArrayList<Object>();
                for (Object o : (List)element) {
                    convertedElements.add(Util.smartAddToJsonForConfigurationConverter(o));
                }
                json.put(key, convertedElements);
            } else {
                json.put(key, new ArrayList());
            }
        } else {
            json.put(key, Util.smartAddToJsonForConfigurationConverter(element));
        }
    }

    private static Object smartAddToJsonForConfigurationConverter(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Color) {
            return Util.convertColorToJs((Color)object);
        }
        if (object instanceof Double) {
            return Util.roundToDecimals((Double)object, 3);
        }
        if (object instanceof Number) {
            return Util.roundToDecimals(((Number)object).doubleValue(), 3);
        }
        if (object instanceof JSONObject || object instanceof JSONArray) {
            return object;
        }
        if (object instanceof AbstractChartOption) {
            return ((AbstractChartOption)object).toJson();
        }
        if (object instanceof ChartData) {
            return ((ChartData)object).toJson();
        }
        if (object instanceof MixedChartData) {
            return ((MixedChartData)object).toJson();
        }
        if (object instanceof MixedChart) {
            return ((MixedChart)object).toJson();
        }
        if (object instanceof AnimationEasingType) {
            return ((AnimationEasingType)((Object)object)).getKey();
        }
        return object;
    }

    private static String convertColorToJs(Color color) {
        if (color.getAlpha() != 255) {
            return "rgba(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + Util.roundToDecimals(Util.mapRange(0.0, 255.0, 0.0, 1.0, color.getAlpha()), 3) + ")";
        }
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    public static double mapRange(double a1, double a2, double b1, double b2, double s) {
        return b1 + (s - a1) * (b2 - b1) / (a2 - a1);
    }

    public static double roundToDecimals(double d, int c) {
        return (double)((int)(d * Math.pow(10.0, c))) / Math.pow(10.0, c);
    }

    public static String finalizeBuildString(String build) {
        for (String identifier : STRING_ARRAY_IDENTIFIERS) {
            build = Util.replaceIdentifierWithContextIndexFunction(build, identifier, true);
        }
        for (String identifier : INTEGER_ARRAY_IDENTIFIERS) {
            build = Util.replaceIdentifierWithContextIndexFunction(build, identifier, false);
        }
        return build;
    }

    private static String replaceIdentifierWithContextIndexFunction(String build, String identifier, boolean valueTypeIsString) {
        Pattern searchPattern = Pattern.compile(String.format(INSERT_PATTERN, identifier));
        Matcher matcher = searchPattern.matcher(build);
        while (matcher.find()) {
            String dataString;
            HashMap<String, List<Integer>> indexedValues = new HashMap<String, List<Integer>>();
            int index = 0;
            if (valueTypeIsString) {
                for (String value : Arrays.stream(matcher.group(3).replaceAll("^[\"'](.+)[\"']$", "$1").split("[\"'],[\"']")).collect(Collectors.toList())) {
                    indexedValues.computeIfAbsent(value, k -> new ArrayList()).add(index);
                    ++index;
                }
            } else {
                for (String value : Arrays.stream(matcher.group(3).split(",")).collect(Collectors.toList())) {
                    indexedValues.computeIfAbsent(value, k -> new ArrayList()).add(index);
                    ++index;
                }
            }
            int dataSize = (dataString = Util.nonNull(matcher.group(2), matcher.group(5)).replaceAll("[{}]", "")).contains("\"") ? dataString.replaceAll("[{}]", "").split("\"?,\"").length : dataString.replaceAll("[{}]", "").split(",").length;
            if (dataString.contains("\"x\"") && dataString.contains("\"y\"")) {
                dataSize = dataString.contains("\"r\"") ? (dataSize /= 3) : (dataSize /= 2);
            }
            if (dataSize > 0 && dataSize > index) continue;
            if (indexedValues.size() == 1) {
                build = build.replace(matcher.group(), Util.nonNull(matcher.group(1)) + "\"" + identifier + "\":[" + (valueTypeIsString ? "'" : "") + indexedValues.keySet().stream().findFirst().orElse("") + (valueTypeIsString ? "'" : "") + "]" + Util.nonNull(matcher.group(4)));
                continue;
            }
            String function = Util.makeContextIndexFunctionFromValues(indexedValues, valueTypeIsString);
            function = build.replace(matcher.group(), Util.nonNull(matcher.group(1)) + "\"" + identifier + "\":" + function + Util.nonNull(matcher.group(4)));
            if (function.length() >= build.length()) continue;
            build = function;
        }
        return build;
    }

    private static String makeContextIndexFunctionFromValues(Map<String, List<Integer>> indexedValues, boolean valueTypeIsString) {
        StringBuilder function = new StringBuilder();
        function.append("function(c){");
        boolean isFirst = true;
        Iterator i = indexedValues.entrySet().stream().sorted(Comparator.comparing(o -> ((List)o.getValue()).size())).iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            if (i.hasNext()) {
                if (!isFirst) {
                    function.append("else ");
                }
                function.append("if([").append(((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining(","))).append("].indexOf(c.dataIndex)>-1)return");
            } else {
                function.append("return");
            }
            if (valueTypeIsString) {
                function.append("'");
            } else {
                function.append(" ");
            }
            function.append((String)entry.getKey());
            if (valueTypeIsString) {
                function.append("'");
            }
            function.append(";");
            isFirst = false;
        }
        function.append("}");
        return function.toString();
    }

    private static String nonNull(String ... s) {
        for (String test : s) {
            if (test == null) continue;
            return test;
        }
        return "";
    }
}

