/*
 * Decompiled with CFR 0.152.
 */
package de.yanwittmann.j2chartjs.quick;

import de.yanwittmann.j2chartjs.data.BarChartData;
import de.yanwittmann.j2chartjs.data.BubbleChartData;
import de.yanwittmann.j2chartjs.data.ChartData;
import de.yanwittmann.j2chartjs.data.LineChartData;
import de.yanwittmann.j2chartjs.data.ScatterChartData;
import de.yanwittmann.j2chartjs.options.AbstractChartOption;
import de.yanwittmann.j2chartjs.options.ChartOptions;
import de.yanwittmann.j2chartjs.options.interaction.InteractionOption;
import de.yanwittmann.j2chartjs.options.plugins.title.TitleOption;
import de.yanwittmann.j2chartjs.options.scale.LinearScaleOption;
import de.yanwittmann.j2chartjs.options.scale.RadialScaleOption;
import de.yanwittmann.j2chartjs.options.scale.ScaleGridOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class QuickChart<T extends QuickChart<?, ?>, D extends ChartData<?, ?, ?>> {
    protected D chartData;
    protected final ChartOptions chartOptions = new ChartOptions();
    private final Map<String, AbstractChartOption> scales = new HashMap<String, AbstractChartOption>();

    public QuickChart(D chartData) {
        this.chartData = chartData;
    }

    public T addLabels(Collection<?> labels) {
        ((ChartData)this.chartData).addLabels(labels.stream().map(Object::toString).collect(Collectors.toList()));
        return (T)this;
    }

    public T addLabels(Object ... labels) {
        ((ChartData)this.chartData).addLabels(Arrays.stream(labels).map(Object::toString).collect(Collectors.toList()));
        return (T)this;
    }

    public T setTitle(String title) {
        this.chartOptions.setTitle(new TitleOption().setDisplay(true).setText(title));
        return (T)this;
    }

    public T setGridLinesVisible(boolean visible) {
        if (this.chartData instanceof BarChartData || this.chartData instanceof LineChartData || this.chartData instanceof BubbleChartData || this.chartData instanceof ScatterChartData) {
            if (this.scales.containsKey("x")) {
                ((LinearScaleOption)this.scales.get("x")).setGrid(new ScaleGridOption().setDisplay(visible));
            } else {
                this.scales.put("x", new LinearScaleOption().setGrid(new ScaleGridOption().setDisplay(visible)));
            }
            if (this.scales.containsKey("y")) {
                ((LinearScaleOption)this.scales.get("y")).setGrid(new ScaleGridOption().setDisplay(visible));
            } else {
                this.scales.put("y", new LinearScaleOption().setGrid(new ScaleGridOption().setDisplay(visible)));
            }
        } else if (this.scales.containsKey("r")) {
            ((RadialScaleOption)this.scales.get("r")).setGrid(new ScaleGridOption().setDisplay(visible));
        } else {
            this.scales.put("r", new RadialScaleOption().setGrid(new ScaleGridOption().setDisplay(visible)));
        }
        this.refreshScaleOptions();
        return (T)this;
    }

    public T setBeginAtZero(boolean beginAtZero) {
        if (this.chartData instanceof BarChartData || this.chartData instanceof LineChartData || this.chartData instanceof BubbleChartData || this.chartData instanceof ScatterChartData) {
            if (this.scales.containsKey("x")) {
                ((LinearScaleOption)this.scales.get("x")).setBeginAtZero(beginAtZero);
            } else {
                this.scales.put("x", new LinearScaleOption().setBeginAtZero(beginAtZero));
            }
            if (this.scales.containsKey("y")) {
                ((LinearScaleOption)this.scales.get("y")).setBeginAtZero(beginAtZero);
            } else {
                this.scales.put("y", new LinearScaleOption().setBeginAtZero(beginAtZero));
            }
        } else if (this.scales.containsKey("r")) {
            ((RadialScaleOption)this.scales.get("r")).setBeginAtZero(beginAtZero);
        } else {
            this.scales.put("r", new RadialScaleOption().setBeginAtZero(beginAtZero));
        }
        this.refreshScaleOptions();
        return (T)this;
    }

    private void refreshScaleOptions() {
        this.chartOptions.clearScales();
        for (Map.Entry<String, AbstractChartOption> scale : this.scales.entrySet()) {
            if (scale.getValue() instanceof LinearScaleOption) {
                this.chartOptions.addScale(scale.getKey(), (LinearScaleOption)scale.getValue());
                continue;
            }
            if (!(scale.getValue() instanceof RadialScaleOption)) continue;
            this.chartOptions.addScale(scale.getKey(), (RadialScaleOption)scale.getValue());
        }
    }

    public T setIndexMode(boolean indexMode) {
        if (indexMode) {
            this.chartOptions.setInteraction(new InteractionOption().setMode("index"));
        } else {
            this.chartOptions.setInteraction(new InteractionOption().setMode("nearest"));
        }
        return (T)this;
    }

    public abstract String build();

    public String toString() {
        return this.build();
    }
}

