/*
 * Decompiled with CFR 0.152.
 */
package de.yanwittmann.j2chartjs.quick;

import de.yanwittmann.j2chartjs.datapoint.BubbleChartDatapoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class QuickBubbleChartDataset {
    private final List<Number> x = new ArrayList<Number>();
    private final List<Number> y = new ArrayList<Number>();
    private final List<Number> r = new ArrayList<Number>();

    public QuickBubbleChartDataset addX(Number ... data) {
        this.x.addAll(Arrays.asList(data));
        return this;
    }

    public QuickBubbleChartDataset addY(Number ... data) {
        this.y.addAll(Arrays.asList(data));
        return this;
    }

    public QuickBubbleChartDataset addR(Number ... data) {
        this.r.addAll(Arrays.asList(data));
        return this;
    }

    public QuickBubbleChartDataset addXYR(Number x, Number y, Number r) {
        this.x.add(x);
        this.y.add(y);
        this.r.add(r);
        return this;
    }

    public QuickBubbleChartDataset addX(Collection<Number> data) {
        this.x.addAll(data);
        return this;
    }

    public QuickBubbleChartDataset addY(Collection<Number> data) {
        this.y.addAll(data);
        return this;
    }

    public QuickBubbleChartDataset addR(Collection<Number> data) {
        this.r.addAll(data);
        return this;
    }

    public List<BubbleChartDatapoint> toDatapoints() {
        ArrayList<BubbleChartDatapoint> datapoints = new ArrayList<BubbleChartDatapoint>();
        for (int i = 0; i < this.x.size() || i < this.y.size() || i < this.r.size(); ++i) {
            datapoints.add(new BubbleChartDatapoint(i < this.x.size() ? (Number)this.x.get(i) : (Number)0, i < this.y.size() ? (Number)this.y.get(i) : (Number)0, i < this.r.size() ? (Number)this.r.get(i) : (Number)0));
        }
        return datapoints;
    }
}

