/*
 * Decompiled with CFR 0.152.
 */
package de.yanwittmann.j2chartjs.options;

import de.yanwittmann.j2chartjs.options.AbstractChartOption;
import de.yanwittmann.j2chartjs.options.animation.AnimationPropertyOption;
import de.yanwittmann.j2chartjs.options.animation.ChartAnimationOption;
import de.yanwittmann.j2chartjs.options.animation.PropertyAnimationOption;
import de.yanwittmann.j2chartjs.options.animation.TransitionAnimationOption;
import de.yanwittmann.j2chartjs.options.animation.TransitionAnimationType;
import de.yanwittmann.j2chartjs.options.interaction.InteractionOption;
import de.yanwittmann.j2chartjs.options.layout.LayoutOption;
import de.yanwittmann.j2chartjs.options.plugins.legend.LegendOption;
import de.yanwittmann.j2chartjs.options.plugins.title.TitleOption;
import de.yanwittmann.j2chartjs.options.plugins.tooltip.TooltipOption;
import de.yanwittmann.j2chartjs.options.scale.LinearScaleOption;
import de.yanwittmann.j2chartjs.options.scale.RadialScaleOption;
import de.yanwittmann.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ChartOptions
extends AbstractChartOption {
    private AbstractChartOption interaction;
    private AbstractChartOption layout;
    private AbstractChartOption legend;
    private AbstractChartOption title;
    private AbstractChartOption subtitle;
    private AbstractChartOption tooltip;
    private AbstractChartOption animation;
    private final Map<String, AbstractChartOption> scales = new HashMap<String, AbstractChartOption>();
    private final Map<String, AbstractChartOption> animations = new HashMap<String, AbstractChartOption>();
    private final Map<String, AbstractChartOption> transitions = new HashMap<String, AbstractChartOption>();
    private Boolean animationsActive;
    private Boolean responsive;
    private Boolean maintainAspectRatio;
    private Double aspectRatio;
    private Integer resizeDelay;
    private Integer devicePixelRatio;
    private String locale;

    public ChartOptions setInteraction(InteractionOption interaction) {
        this.interaction = interaction;
        return this;
    }

    public ChartOptions setLayout(LayoutOption layout) {
        this.layout = layout;
        return this;
    }

    public ChartOptions setLegend(LegendOption legend) {
        this.legend = legend;
        return this;
    }

    public ChartOptions setTitle(TitleOption title) {
        this.title = title;
        return this;
    }

    public ChartOptions setSubtitle(AbstractChartOption subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public ChartOptions setTooltip(TooltipOption tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ChartOptions setChartAnimation(ChartAnimationOption animation) {
        this.animation = animation;
        return this;
    }

    public ChartOptions addPropertyAnimation(AnimationPropertyOption key, PropertyAnimationOption animation) {
        this.animations.put(key.getKey(), animation);
        return this;
    }

    public ChartOptions addTransition(TransitionAnimationType key, TransitionAnimationOption transitions) {
        this.transitions.put(key.getKey(), transitions);
        return this;
    }

    public ChartOptions addScale(String key, LinearScaleOption linearScaleOption) {
        this.scales.put(key, linearScaleOption);
        return this;
    }

    public ChartOptions addScale(String key, RadialScaleOption radialScaleOption) {
        this.scales.put(key, radialScaleOption);
        return this;
    }

    public ChartOptions clearScales() {
        this.scales.clear();
        return this;
    }

    public ChartOptions setOption(AbstractChartOption option) {
        if (option instanceof InteractionOption) {
            this.interaction = option;
        } else if (option instanceof LayoutOption) {
            this.layout = option;
        } else if (option instanceof LegendOption) {
            this.legend = option;
        } else if (option instanceof TitleOption) {
            this.title = option;
        } else if (option instanceof TooltipOption) {
            this.tooltip = option;
        } else if (option instanceof ChartAnimationOption) {
            this.animation = option;
        }
        return this;
    }

    public ChartOptions setAnimationsActive(boolean active) {
        this.animationsActive = active;
        return this;
    }

    public ChartOptions setResponsive(Boolean responsive) {
        this.responsive = responsive;
        return this;
    }

    public ChartOptions setMaintainAspectRatio(Boolean maintainAspectRatio) {
        this.maintainAspectRatio = maintainAspectRatio;
        return this;
    }

    public ChartOptions setAspectRatio(Double aspectRatio) {
        this.aspectRatio = aspectRatio;
        return this;
    }

    public ChartOptions setResizeDelay(Integer resizeDelay) {
        this.resizeDelay = resizeDelay;
        return this;
    }

    public ChartOptions setDevicePixelRatio(Integer devicePixelRatio) {
        this.devicePixelRatio = devicePixelRatio;
        return this;
    }

    public ChartOptions setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public JSONObject toJson() {
        JSONObject optionsJson = new JSONObject();
        Util.addToJson(optionsJson, "interaction", this.interaction);
        Util.addToJson(optionsJson, "layout", this.layout);
        if (this.legend != null || this.title != null || this.subtitle != null || this.tooltip != null) {
            JSONObject pluginsJson = new JSONObject();
            Util.addToJson(pluginsJson, "legend", this.legend);
            Util.addToJson(pluginsJson, "title", this.title);
            Util.addToJson(pluginsJson, "subtitle", this.subtitle);
            Util.addToJson(pluginsJson, "tooltip", this.tooltip);
            optionsJson.put("plugins", (Object)pluginsJson);
        }
        if (Boolean.FALSE.equals(this.animationsActive)) {
            optionsJson.put("animation", false);
        } else {
            if (this.animation != null) {
                optionsJson.put("animation", (Object)this.animation.toJson());
            }
            if (this.animations.size() > 0) {
                JSONObject animationsJson = new JSONObject();
                for (Map.Entry<String, AbstractChartOption> entry : this.animations.entrySet()) {
                    if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                    animationsJson.put(entry.getKey(), (Object)entry.getValue().toJson());
                }
                optionsJson.put("animations", (Object)animationsJson);
            }
        }
        if (this.scales.size() > 0) {
            JSONObject scalesJson = new JSONObject();
            for (Map.Entry<String, AbstractChartOption> entry : this.scales.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                scalesJson.put(entry.getKey(), (Object)entry.getValue().toJson());
            }
            optionsJson.put("scales", (Object)scalesJson);
        }
        if (this.transitions.size() > 0) {
            JSONObject transitionsJson = new JSONObject();
            for (Map.Entry<String, AbstractChartOption> entry : this.transitions.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                transitionsJson.put(entry.getKey(), (Object)entry.getValue().toJson());
            }
            optionsJson.put("transitions", (Object)transitionsJson);
        }
        Util.addToJson(optionsJson, "responsive", this.responsive);
        Util.addToJson(optionsJson, "maintainAspectRatio", this.maintainAspectRatio);
        Util.addToJson(optionsJson, "aspectRatio", this.aspectRatio);
        Util.addToJson(optionsJson, "resizeDelay", this.resizeDelay);
        Util.addToJson(optionsJson, "devicePixelRatio", this.devicePixelRatio);
        return optionsJson;
    }
}

