/*
 * Decompiled with CFR 0.152.
 */
package de.yanwittmann.j2chartjs.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.json.JSONObject;

public abstract class ChartDataset<T, D> {
    protected final List<D> data = new ArrayList<D>();

    public T setData(Collection<? extends D> data) {
        this.clearData();
        this.data.addAll(data);
        return (T)this;
    }

    public T setData(D ... data) {
        this.clearData();
        this.data.addAll(Arrays.asList(data));
        return (T)this;
    }

    public T addData(Collection<? extends D> data) {
        this.data.addAll(data);
        return (T)this;
    }

    public T addData(D ... data) {
        this.data.addAll(Arrays.asList(data));
        return (T)this;
    }

    public List<D> getData() {
        return this.data;
    }

    public T clearData() {
        this.data.clear();
        return (T)this;
    }

    public abstract JSONObject toJson();
}

